/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.util;

import org.apache.reef.util.Optional;

public final class SetOnce<T> {
    private Optional<T> value;

    public SetOnce(T value) {
        this.set(value);
    }

    public SetOnce() {
        this.value = Optional.empty();
    }

    public synchronized T get() {
        return (T)this.value.get();
    }

    public synchronized void set(T value) {
        if (this.value.isPresent()) {
            throw new IllegalStateException("Trying to set new value " + value + " while an old value was already present: " + this.value);
        }
        this.value = Optional.of(value);
    }

    public synchronized boolean isSet() {
        return this.value.isPresent();
    }
}

