/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;

public final class REEFVersion {
    private static final Logger LOG = Logger.getLogger(REEFVersion.class.getName());
    private static final String FILENAME = "version.properties";
    private static final String VERSION_KEY = "version";
    private static final String VERSION_DEFAULT = "unknown";
    private final String version = REEFVersion.loadVersion();

    @Inject
    public REEFVersion() {
    }

    public void logVersion() {
        this.logVersion(Level.INFO);
    }

    public void logVersion(Level logLevel) {
        LOG.log(logLevel, "REEF Version: {0}", this.version);
    }

    public String getVersion() {
        return this.version;
    }

    private static String loadVersion() {
        String version;
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(FILENAME);){
            if (is == null) {
                throw new IOException("version.properties not found");
            }
            Properties properties = new Properties();
            properties.load(is);
            version = properties.getProperty(VERSION_KEY, VERSION_DEFAULT);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Could not find REEF version");
            version = VERSION_DEFAULT;
        }
        return version;
    }
}

