/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.util;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OSUtils {
    private static final Logger LOG = Logger.getLogger(OSUtils.class.getName());

    private OSUtils() {
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    public static long getPID() {
        if (OSUtils.isLinux()) {
            try {
                Process process = new ProcessBuilder(new String[0]).command("bash", "-c", "echo $PPID").start();
                byte[] returnBytes = new byte[128];
                process.getInputStream().read(returnBytes);
                Long result = Long.valueOf(new String(returnBytes).trim());
                process.destroy();
                return result;
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Unable to determine PID", e);
                return -1L;
            }
        }
        return -1L;
    }

    public static void kill(long pid) throws IOException, InterruptedException {
        if (!OSUtils.isLinux()) {
            throw new UnsupportedOperationException("Unable to execute kill on non-linux OS");
        }
        Process process = new ProcessBuilder(new String[0]).command("bash", "-c", "kill", "-9", String.valueOf(pid)).start();
        int returnCode = process.waitFor();
        LOG.fine("Kill returned: " + returnCode);
    }

    public static String formatVariable(String variableName) {
        if (OSUtils.isWindows()) {
            return "%" + variableName + "%";
        }
        return "$" + variableName;
    }
}

