/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;

public final class MemoryUtils {
    private static final int MBs = 0x100000;

    private MemoryUtils() {
    }

    public static String memPoolNames() {
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        StringBuilder output = new StringBuilder();
        for (MemoryPoolMXBean bean : memoryPoolMXBeans) {
            output.append(bean.getName());
            output.append(",");
        }
        output.deleteCharAt(output.length() - 1);
        return output.toString();
    }

    public static long currentEdenMemoryUsageMB() {
        return MemoryUtils.currentMemoryUsage("eden");
    }

    public static long currentOldMemoryUsageMB() {
        return MemoryUtils.currentMemoryUsage("old");
    }

    public static long currentPermMemoryUsageMB() {
        return MemoryUtils.currentMemoryUsage("perm");
    }

    private static long currentMemoryUsage(String name) {
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean bean : memoryPoolMXBeans) {
            if (bean.getName().toLowerCase().indexOf(name) == -1) continue;
            return bean.getUsage().getUsed() / 0x100000L;
        }
        return 0L;
    }

    public static long peakEdenMemoryUsageMB() {
        return MemoryUtils.peakMemoryUsage("eden");
    }

    public static long peakOldMemoryUsageMB() {
        return MemoryUtils.peakMemoryUsage("old");
    }

    public static long peakPermMemoryUsageMB() {
        return MemoryUtils.peakMemoryUsage("perm");
    }

    private static long peakMemoryUsage(String name) {
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean bean : memoryPoolMXBeans) {
            if (bean.getName().toLowerCase().indexOf(name) == -1) continue;
            return bean.getPeakUsage().getUsed() / 0x100000L;
        }
        return 0L;
    }

    public static void resetPeakUsage() {
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            memoryPoolMXBean.resetPeakUsage();
        }
    }

    public static void main(String[] args) {
        System.out.println(MemoryUtils.memPoolNames());
        byte[] b = new byte[0x1000000];
        System.out.println(MemoryUtils.currentEdenMemoryUsageMB() + "," + MemoryUtils.currentOldMemoryUsageMB() + "," + MemoryUtils.currentPermMemoryUsageMB());
        System.gc();
        System.out.println(MemoryUtils.currentEdenMemoryUsageMB() + "," + MemoryUtils.currentOldMemoryUsageMB() + "," + MemoryUtils.currentPermMemoryUsageMB());
        System.out.println(MemoryUtils.peakEdenMemoryUsageMB() + "," + MemoryUtils.peakOldMemoryUsageMB() + "," + MemoryUtils.peakPermMemoryUsageMB());
        MemoryUtils.resetPeakUsage();
        System.out.println(MemoryUtils.peakEdenMemoryUsageMB() + "," + MemoryUtils.peakOldMemoryUsageMB() + "," + MemoryUtils.peakPermMemoryUsageMB());
    }
}

