/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.utils.IOUtils;

public class JARFileMaker
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(JARFileMaker.class.getName());
    private final FileOutputStream fileOutputStream;
    private final JarOutputStream jarOutputStream;
    private String relativeStartCanonicalPath = null;

    public JARFileMaker(File outputFile, Manifest manifest) throws IOException {
        this.fileOutputStream = new FileOutputStream(outputFile);
        this.jarOutputStream = new JarOutputStream((OutputStream)this.fileOutputStream, manifest);
    }

    public JARFileMaker(File outputFile) throws IOException {
        this.fileOutputStream = new FileOutputStream(outputFile);
        this.jarOutputStream = new JarOutputStream(this.fileOutputStream);
    }

    public JARFileMaker add(File inputFile) throws IOException {
        String fileNameInJAR = this.makeRelative(inputFile);
        if (inputFile.isDirectory()) {
            JarEntry entry = new JarEntry(fileNameInJAR);
            entry.setTime(inputFile.lastModified());
            this.jarOutputStream.putNextEntry(entry);
            this.jarOutputStream.closeEntry();
            for (File nestedFile : inputFile.listFiles()) {
                this.add(nestedFile);
            }
            return this;
        }
        JarEntry entry = new JarEntry(fileNameInJAR);
        entry.setTime(inputFile.lastModified());
        this.jarOutputStream.putNextEntry(entry);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFile));){
            IOUtils.copy((InputStream)in, (OutputStream)this.jarOutputStream);
            this.jarOutputStream.closeEntry();
        }
        catch (FileNotFoundException ex) {
            LOG.log(Level.WARNING, "Skip the file: " + inputFile, ex);
        }
        return this;
    }

    public JARFileMaker addChildren(File folder) throws IOException {
        this.relativeStartCanonicalPath = folder.getCanonicalPath();
        for (File f : folder.listFiles()) {
            this.add(f);
        }
        this.relativeStartCanonicalPath = null;
        return this;
    }

    private String makeRelative(File input) throws IOException {
        String result = this.relativeStartCanonicalPath == null ? input.getCanonicalPath() : input.getCanonicalPath().replace(this.relativeStartCanonicalPath, "").substring(1);
        if (input.isDirectory()) {
            return result.replace("\\", "/") + "/";
        }
        return result.replace("\\", "/");
    }

    @Override
    public void close() throws IOException {
        this.jarOutputStream.close();
        this.fileOutputStream.close();
    }
}

