/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.util;

import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.tang.formats.ConfigurationModule;
import org.apache.reef.tang.formats.OptionalParameter;
import org.apache.reef.tang.formats.Param;

public final class EnvironmentUtils {
    private static final Logger LOG = Logger.getLogger(EnvironmentUtils.class.getName());

    public static Set<String> getAllClasspathJars() {
        return EnvironmentUtils.getAllClasspathJars("JAVA_HOME", "YARN_HOME", "HADOOP_HOME", "HADOOP_YARN_HOME", "HADOOP_HDFS_HOME", "HADOOP_COMMON_HOME", "HADOOP_MAPRED_HOME", "YARN_CONF_DIR", "HADOOP_CONF_DIR");
    }

    public static Set<String> getAllClasspathJars(String ... excludeEnv) {
        HashSet<String> jars = new HashSet<String>();
        HashSet<Path> excludePaths = new HashSet<Path>();
        for (String env : excludeEnv) {
            File file;
            String path = System.getenv(env);
            if (null == path || !(file = new File(path)).exists()) continue;
            excludePaths.add(file.toPath());
        }
        for (String path : System.getProperty("java.class.path").split(File.pathSeparator)) {
            try {
                File file = new File(path);
                if (!file.exists()) continue;
                Path absolutePath = file.toPath();
                boolean toBeAdded = true;
                for (Path prefix : excludePaths) {
                    if (!absolutePath.startsWith(prefix)) continue;
                    toBeAdded = false;
                }
                if (!toBeAdded) continue;
                jars.add(absolutePath.toString());
            }
            catch (InvalidPathException ex) {
                LOG.log(Level.FINE, "Skip path: {0}: {1}", new Object[]{path, ex});
            }
        }
        return jars;
    }

    @Deprecated
    public static <P extends Param> ConfigurationModule addAll(ConfigurationModule config, P param, Iterable<String> values) {
        for (String val : values) {
            config = config.set(param, val);
        }
        return config;
    }

    @Deprecated
    public static ConfigurationModule addClasspath(ConfigurationModule config, OptionalParameter<String> param) {
        return EnvironmentUtils.addAll(config, param, EnvironmentUtils.getAllClasspathJars());
    }

    public static boolean areAssertionsEnabled() {
        try {
            assert (false);
            return false;
        }
        catch (AssertionError assertionError) {
            return true;
        }
    }

    public static String getClassLocation(Class<?> clazz) {
        return clazz.getProtectionDomain().getCodeSource().getLocation().getFile();
    }
}

