/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.util.OSUtils;

public final class CommandUtils {
    private static final Logger LOG = Logger.getLogger(CommandUtils.class.getName());

    public static final String runCommand(String command) {
        StringBuilder sb = new StringBuilder();
        try {
            String cmd = OSUtils.isWindows() ? "cmd.exe /c " + command : command;
            Process proc = Runtime.getRuntime().exec(cmd);
            try (BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                String line;
                while ((line = input.readLine()) != null) {
                    sb.append(line).append('\n');
                }
            }
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Error in call: " + command, ex);
            sb.append(ex);
        }
        return sb.toString();
    }
}

