/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.remote.RemoteIdentifierFactory;
import org.apache.reef.wake.remote.RemoteMessage;

public class RemoteManager {
    private static final Logger LOG = Logger.getLogger(RemoteManager.class.getName());
    private final org.apache.reef.wake.remote.RemoteManager raw;
    private final RemoteIdentifierFactory factory;

    @Inject
    public RemoteManager(org.apache.reef.wake.remote.RemoteManager raw, RemoteIdentifierFactory factory) {
        this.raw = raw;
        this.factory = factory;
        LOG.log(Level.FINE, "Instantiated 'RemoteManager' with remoteId: {0}", this.getMyIdentifier());
    }

    public final org.apache.reef.wake.remote.RemoteManager raw() {
        return this.raw;
    }

    public void close() throws Exception {
        this.raw.close();
    }

    public <T> EventHandler<T> getHandler(String destinationIdentifier, Class<? extends T> messageType) {
        return this.raw.getHandler(this.factory.getNewInstance(destinationIdentifier), messageType);
    }

    public <T, U extends T> AutoCloseable registerHandler(String sourceIdentifier, Class<U> messageType, EventHandler<T> theHandler) {
        return this.raw.registerHandler(this.factory.getNewInstance(sourceIdentifier), messageType, theHandler);
    }

    public <T, U extends T> AutoCloseable registerHandler(Class<U> messageType, EventHandler<RemoteMessage<T>> theHandler) {
        return this.raw.registerHandler(messageType, theHandler);
    }

    public AutoCloseable registerErrorHandler(EventHandler<Exception> theHandler) {
        return this.raw.registerErrorHandler(theHandler);
    }

    public String getMyIdentifier() {
        return this.raw.getMyIdentifier().toString();
    }
}

