/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.utils;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.lang.SerializationException;
import org.apache.commons.lang.SerializationUtils;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.runtime.common.utils.ExceptionCodec;
import org.apache.reef.util.Optional;

@Private
final class DefaultExceptionCodec
implements ExceptionCodec {
    private static final Logger LOG = Logger.getLogger(DefaultExceptionCodec.class.getName());

    @Inject
    DefaultExceptionCodec() {
    }

    @Override
    public Optional<Throwable> fromBytes(byte[] bytes) {
        try {
            return Optional.of((Object)((Throwable)SerializationUtils.deserialize((byte[])bytes)));
        }
        catch (IllegalArgumentException | SerializationException e) {
            LOG.log(Level.FINE, "Unable to deserialize a Throwable.", e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<Throwable> fromBytes(Optional<byte[]> bytes) {
        if (bytes.isPresent()) {
            return this.fromBytes((byte[])bytes.get());
        }
        return Optional.empty();
    }

    @Override
    public byte[] toBytes(Throwable throwable) {
        return SerializationUtils.serialize((Serializable)throwable);
    }
}

