/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.launch;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.runtime.common.launch.REEFErrorHandler;

final class REEFUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOG = Logger.getLogger(REEFUncaughtExceptionHandler.class.getName());
    private final REEFErrorHandler errorHandler;

    @Inject
    REEFUncaughtExceptionHandler(REEFErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public final synchronized void uncaughtException(Thread thread, Throwable throwable) {
        String msg = "Thread " + thread.getName() + " threw an uncaught exception.";
        LOG.log(Level.SEVERE, msg, throwable);
        this.errorHandler.onNext(new Exception(msg, throwable));
        try {
            this.wait(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.errorHandler.close();
        LOG.log(Level.SEVERE, "System.exit(1)");
        System.exit(1);
    }

    public String toString() {
        return "REEFUncaughtExceptionHandler{errorHandler=" + this.errorHandler + '}';
    }
}

