/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.launch;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import javax.inject.Inject;
import org.apache.reef.annotations.Provided;
import org.apache.reef.annotations.audience.ClientSide;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.EvaluatorSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.proto.ClientRuntimeProtocol;
import org.apache.reef.proto.EvaluatorRuntimeProtocol;
import org.apache.reef.proto.REEFProtocol;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.wake.remote.Codec;

@Private
@Provided
@ClientSide
@DriverSide
@EvaluatorSide
public final class REEFMessageCodec
implements Codec<GeneratedMessage> {
    @Inject
    private REEFMessageCodec() {
    }

    public GeneratedMessage decode(byte[] bytes) {
        try {
            REEFProtocol.REEFMessage message = REEFProtocol.REEFMessage.parseFrom(bytes);
            if (message.hasJobControl()) {
                return message.getJobControl();
            }
            if (message.hasRuntimeError()) {
                return message.getRuntimeError();
            }
            if (message.hasJobStatus()) {
                return message.getJobStatus();
            }
            if (message.hasEvaluatorControl()) {
                return message.getEvaluatorControl();
            }
            if (message.hasEvaluatorHeartBeat()) {
                return message.getEvaluatorHeartBeat();
            }
            throw new RuntimeException("Unable to decode a message: " + message.toString());
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Unable to decode a message", e);
        }
    }

    public byte[] encode(GeneratedMessage msg) {
        REEFProtocol.REEFMessage.Builder message = REEFProtocol.REEFMessage.newBuilder();
        if (msg instanceof ClientRuntimeProtocol.JobControlProto) {
            message.setJobControl((ClientRuntimeProtocol.JobControlProto)msg);
        } else if (msg instanceof ReefServiceProtos.RuntimeErrorProto) {
            message.setRuntimeError((ReefServiceProtos.RuntimeErrorProto)msg);
        } else if (msg instanceof ReefServiceProtos.JobStatusProto) {
            message.setJobStatus((ReefServiceProtos.JobStatusProto)msg);
        } else if (msg instanceof EvaluatorRuntimeProtocol.EvaluatorControlProto) {
            message.setEvaluatorControl((EvaluatorRuntimeProtocol.EvaluatorControlProto)msg);
        } else if (msg instanceof EvaluatorRuntimeProtocol.EvaluatorHeartbeatProto) {
            message.setEvaluatorHeartBeat((EvaluatorRuntimeProtocol.EvaluatorHeartbeatProto)msg);
        } else {
            throw new RuntimeException("Unable to serialize: " + msg);
        }
        return message.build().toByteArray();
    }
}

