/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.launch;

import com.google.protobuf.ByteString;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.launch.parameters.ErrorHandlerRID;
import org.apache.reef.runtime.common.launch.parameters.LaunchID;
import org.apache.reef.runtime.common.utils.ExceptionCodec;
import org.apache.reef.runtime.common.utils.RemoteManager;
import org.apache.reef.tang.InjectionFuture;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.wake.EventHandler;

public final class REEFErrorHandler
implements EventHandler<Throwable> {
    private static final Logger LOG = Logger.getLogger(REEFErrorHandler.class.getName());
    private final InjectionFuture<RemoteManager> remoteManager;
    private final String launchID;
    private final String errorHandlerRID;
    private final ExceptionCodec exceptionCodec;

    @Inject
    REEFErrorHandler(InjectionFuture<RemoteManager> remoteManager, @Parameter(value=ErrorHandlerRID.class) String errorHandlerRID, @Parameter(value=LaunchID.class) String launchID, ExceptionCodec exceptionCodec) {
        this.errorHandlerRID = errorHandlerRID;
        this.remoteManager = remoteManager;
        this.launchID = launchID;
        this.exceptionCodec = exceptionCodec;
    }

    public void onNext(Throwable e) {
        LOG.log(Level.SEVERE, "Uncaught exception.", e);
        if (!this.errorHandlerRID.equals("NO_ERROR_HANDLER_REMOTE_ID")) {
            EventHandler<ReefServiceProtos.RuntimeErrorProto> runtimeErrorHandler = ((RemoteManager)this.remoteManager.get()).getHandler(this.errorHandlerRID, ReefServiceProtos.RuntimeErrorProto.class);
            ReefServiceProtos.RuntimeErrorProto message = ReefServiceProtos.RuntimeErrorProto.newBuilder().setName("reef").setIdentifier(this.launchID).setMessage(e.getMessage()).setException(ByteString.copyFrom((byte[])this.exceptionCodec.toBytes(e))).build();
            try {
                runtimeErrorHandler.onNext((Object)message);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Unable to send the error upstream", t);
            }
        } else {
            LOG.log(Level.SEVERE, "Caught an exception from Wake we cannot send upstream because there is no upstream");
        }
    }

    public void close() {
        try {
            ((RemoteManager)this.remoteManager.get()).close();
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, "Unable to close the remote manager", ex);
        }
    }

    public String toString() {
        return "REEFErrorHandler{remoteManager=" + this.remoteManager + ", launchID='" + this.launchID + '\'' + ", errorHandlerRID='" + this.errorHandlerRID + '\'' + '}';
    }
}

