/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.launch;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.runtime.common.launch.parameters.LaunchID;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.profiler.WakeProfiler;
import org.apache.reef.wake.time.event.StopTime;

final class ProfilingStopHandler
implements EventHandler<StopTime> {
    private static final Logger LOG = Logger.getLogger(ProfilingStopHandler.class.getName());
    private static WakeProfiler profiler;
    private final String launchID;

    @Inject
    public ProfilingStopHandler(@Parameter(value=LaunchID.class) String launchID) {
        this.launchID = launchID;
    }

    static void setProfiler(WakeProfiler profiler) {
        ProfilingStopHandler.profiler = profiler;
    }

    public void onNext(StopTime stopTime) {
        try (PrintWriter out = new PrintWriter("profile-" + this.launchID + ".json");){
            out.print(profiler.objectGraphToString());
        }
        catch (FileNotFoundException e) {
            LOG.log(Level.WARNING, "Unable to write the profile", e);
        }
    }
}

