/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.launch;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.runtime.common.evaluator.PIDStoreStartHandler;
import org.apache.reef.runtime.common.launch.ProfilingStopHandler;
import org.apache.reef.runtime.common.launch.REEFErrorHandler;
import org.apache.reef.runtime.common.launch.REEFMessageCodec;
import org.apache.reef.runtime.common.launch.REEFUncaughtExceptionHandler;
import org.apache.reef.runtime.common.launch.parameters.ClockConfigurationPath;
import org.apache.reef.runtime.common.launch.parameters.ErrorHandlerRID;
import org.apache.reef.runtime.common.launch.parameters.LaunchID;
import org.apache.reef.tang.Aspect;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Configurations;
import org.apache.reef.tang.Injector;
import org.apache.reef.tang.JavaConfigurationBuilder;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.annotations.Name;
import org.apache.reef.tang.annotations.NamedParameter;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.tang.formats.ConfigurationSerializer;
import org.apache.reef.util.REEFVersion;
import org.apache.reef.wake.profiler.WakeProfiler;
import org.apache.reef.wake.remote.RemoteConfiguration;
import org.apache.reef.wake.time.Clock;

public final class LaunchClass
implements AutoCloseable,
Runnable {
    private static final Logger LOG = Logger.getLogger(LaunchClass.class.getName());
    private final String launchID;
    private final String errorHandlerID;
    private final String evaluatorConfigurationPath;
    private final boolean isProfilingEnabled;
    private final REEFErrorHandler errorHandler;
    private final ConfigurationSerializer configurationSerializer;
    private WakeProfiler profiler;

    @Inject
    LaunchClass(REEFUncaughtExceptionHandler uncaughtExceptionHandler, REEFErrorHandler errorHandler, @Parameter(value=LaunchID.class) String launchID, @Parameter(value=ErrorHandlerRID.class) String errorHandlerID, @Parameter(value=ClockConfigurationPath.class) String evaluatorConfigurationPath, @Parameter(value=ProfilingEnabled.class) boolean enableProfiling, ConfigurationSerializer configurationSerializer, REEFVersion reefVersion) {
        reefVersion.logVersion();
        this.launchID = launchID;
        this.errorHandlerID = errorHandlerID;
        this.evaluatorConfigurationPath = evaluatorConfigurationPath;
        this.isProfilingEnabled = enableProfiling;
        this.errorHandler = errorHandler;
        this.configurationSerializer = configurationSerializer;
        Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
        if (this.isProfilingEnabled) {
            this.profiler = new WakeProfiler();
            ProfilingStopHandler.setProfiler(this.profiler);
        }
        LOG.log(Level.FINE, "Instantiated LaunchClass");
    }

    private Configuration getClockConfiguration() {
        return Configurations.merge((Configuration[])new Configuration[]{this.readConfigurationFromDisk(), this.getStaticClockConfiguration()});
    }

    private Configuration readConfigurationFromDisk() {
        LOG.log(Level.FINEST, "Loading configuration file: {0}", this.evaluatorConfigurationPath);
        File evaluatorConfigFile = new File(this.evaluatorConfigurationPath);
        if (!evaluatorConfigFile.exists()) {
            String message = "The configuration file " + this.evaluatorConfigurationPath + "doesn't exist. This points to an issue in the job submission.";
            this.fail(message, new FileNotFoundException());
            throw new RuntimeException(message);
        }
        if (!evaluatorConfigFile.canRead()) {
            String message = "The configuration file " + this.evaluatorConfigurationPath + " exists, but can't be read";
            this.fail(message, new IOException());
            throw new RuntimeException(message);
        }
        try {
            return this.configurationSerializer.fromFile(evaluatorConfigFile);
        }
        catch (IOException e) {
            String message = "Unable to parse the configuration file " + this.evaluatorConfigurationPath;
            this.fail(message, e);
            throw new RuntimeException(message, e);
        }
    }

    private Configuration getStaticClockConfiguration() {
        JavaConfigurationBuilder builder = Tang.Factory.getTang().newConfigurationBuilder().bindNamedParameter(LaunchID.class, this.launchID).bindNamedParameter(ErrorHandlerRID.class, this.errorHandlerID).bindSetEntry(Clock.StartHandler.class, PIDStoreStartHandler.class).bindNamedParameter(RemoteConfiguration.ErrorHandler.class, REEFErrorHandler.class).bindNamedParameter(RemoteConfiguration.ManagerName.class, "REEF_LAUNCHER").bindNamedParameter(RemoteConfiguration.MessageCodec.class, REEFMessageCodec.class);
        if (this.isProfilingEnabled) {
            builder.bindSetEntry(Clock.StopHandler.class, ProfilingStopHandler.class);
        }
        return builder.build();
    }

    private Clock getClock() {
        try {
            Injector clockInjector = Tang.Factory.getTang().newInjector(this.getClockConfiguration());
            if (this.isProfilingEnabled) {
                clockInjector.bindAspect((Aspect)this.profiler);
            }
            return (Clock)clockInjector.getInstance(Clock.class);
        }
        catch (Throwable ex) {
            this.fail("Unable to instantiate the clock", ex);
            throw new RuntimeException("Unable to instantiate the clock", ex);
        }
    }

    @Override
    public void run() {
        LOG.entering(this.getClass().getName(), "run", "Starting the clock");
        try {
            this.getClock().run();
        }
        catch (Throwable t) {
            this.fail("Fatal exception while executing the clock", t);
        }
        LOG.exiting(this.getClass().getName(), "run", "Clock terminated");
    }

    @Override
    public void close() throws Exception {
        LOG.entering(this.getClass().getName(), "close");
        this.errorHandler.close();
        LOG.exiting(this.getClass().getName(), "close");
    }

    private void fail(String message, Throwable throwable) {
        this.errorHandler.onNext(new Exception(message, throwable));
    }

    @NamedParameter(doc="If true, profiling will be enabled", short_name="profiling", default_value="false")
    public static final class ProfilingEnabled
    implements Name<Boolean> {
    }
}

