/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.reef.runtime.common.Launcher;
import org.apache.reef.runtime.common.launch.LaunchCommandBuilder;
import org.apache.reef.util.EnvironmentUtils;

public final class JavaLaunchCommandBuilder
implements LaunchCommandBuilder {
    private static final String DEFAULT_JAVA_PATH = System.getenv("JAVA_HOME") + "/bin/" + "java";
    private String stderrPath = null;
    private String stdoutPath = null;
    private String errorHandlerRID = null;
    private String launchID = null;
    private int megaBytes = 0;
    private String evaluatorConfigurationPath = null;
    private String javaPath = null;
    private String classPath = null;
    private Boolean assertionsEnabled = null;

    @Override
    public List<String> build() {
        return new ArrayList<String>(){
            {
                if (JavaLaunchCommandBuilder.this.javaPath == null || JavaLaunchCommandBuilder.this.javaPath.isEmpty()) {
                    this.add(DEFAULT_JAVA_PATH);
                } else {
                    this.add(JavaLaunchCommandBuilder.this.javaPath);
                }
                this.add("-XX:PermSize=128m");
                this.add("-XX:MaxPermSize=128m");
                this.add("-Xmx" + JavaLaunchCommandBuilder.this.megaBytes + "m");
                if (JavaLaunchCommandBuilder.this.assertionsEnabled != null && JavaLaunchCommandBuilder.this.assertionsEnabled.booleanValue() || EnvironmentUtils.areAssertionsEnabled()) {
                    this.add("-ea");
                }
                if (JavaLaunchCommandBuilder.this.classPath != null && !JavaLaunchCommandBuilder.this.classPath.isEmpty()) {
                    this.add("-classpath");
                    this.add(JavaLaunchCommandBuilder.this.classPath);
                }
                Launcher.propagateProperties((Collection<String>)this, true, "proc_reef");
                Launcher.propagateProperties((Collection<String>)this, false, "java.util.logging.config.file", "java.util.logging.config.class");
                this.add(Launcher.class.getName());
                this.add("-error_handler_rid");
                this.add(JavaLaunchCommandBuilder.this.errorHandlerRID);
                this.add("-launch_id");
                this.add(JavaLaunchCommandBuilder.this.launchID);
                this.add("-runtime_configuration");
                this.add(JavaLaunchCommandBuilder.this.evaluatorConfigurationPath);
                if (JavaLaunchCommandBuilder.this.stdoutPath != null && !JavaLaunchCommandBuilder.this.stdoutPath.isEmpty()) {
                    this.add("1>");
                    this.add(JavaLaunchCommandBuilder.this.stdoutPath);
                }
                if (JavaLaunchCommandBuilder.this.stderrPath != null && !JavaLaunchCommandBuilder.this.stderrPath.isEmpty()) {
                    this.add("2>");
                    this.add(JavaLaunchCommandBuilder.this.stderrPath);
                }
            }
        };
    }

    @Override
    public JavaLaunchCommandBuilder setErrorHandlerRID(String errorHandlerRID) {
        this.errorHandlerRID = errorHandlerRID;
        return this;
    }

    @Override
    public JavaLaunchCommandBuilder setLaunchID(String launchID) {
        this.launchID = launchID;
        return this;
    }

    @Override
    public JavaLaunchCommandBuilder setMemory(int megaBytes) {
        this.megaBytes = megaBytes;
        return this;
    }

    @Override
    public JavaLaunchCommandBuilder setConfigurationFileName(String configurationFileName) {
        this.evaluatorConfigurationPath = configurationFileName;
        return this;
    }

    @Override
    public JavaLaunchCommandBuilder setStandardOut(String standardOut) {
        this.stdoutPath = standardOut;
        return this;
    }

    @Override
    public JavaLaunchCommandBuilder setStandardErr(String standardErr) {
        this.stderrPath = standardErr;
        return this;
    }

    public JavaLaunchCommandBuilder setJavaPath(String path) {
        this.javaPath = path;
        return this;
    }

    public JavaLaunchCommandBuilder setClassPath(String classPath) {
        this.classPath = classPath;
        return this;
    }

    public JavaLaunchCommandBuilder setClassPath(Collection<String> classPathElements) {
        this.classPath = StringUtils.join(classPathElements, (char)File.pathSeparatorChar);
        return this;
    }

    public JavaLaunchCommandBuilder enableAssertions(boolean assertionsEnabled) {
        this.assertionsEnabled = assertionsEnabled;
        return this;
    }
}

