/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.launch;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.reef.runtime.common.launch.LaunchCommandBuilder;

public class CLRLaunchCommandBuilder
implements LaunchCommandBuilder {
    private static final Logger LOG = Logger.getLogger(CLRLaunchCommandBuilder.class.getName());
    private static final String EVALUATOR_PATH = "reef/global/Org.Apache.Reef.Evaluator.exe";
    private String standardErrPath = null;
    private String standardOutPath = null;
    private String errorHandlerRID = null;
    private String launchID = null;
    private int megaBytes = 0;
    private String evaluatorConfigurationPath = null;

    @Override
    public List<String> build() {
        LinkedList<String> result = new LinkedList<String>();
        File f = new File(EVALUATOR_PATH);
        if (!f.exists()) {
            LOG.log(Level.WARNING, "file can NOT be found: {0}", f.getAbsolutePath());
        }
        result.add(f.getPath());
        result.add(this.errorHandlerRID);
        result.add(this.evaluatorConfigurationPath);
        if (null != this.standardOutPath && !this.standardOutPath.isEmpty()) {
            result.add(">" + this.standardOutPath);
        }
        if (null != this.standardErrPath && !this.standardErrPath.isEmpty()) {
            result.add("2>" + this.standardErrPath);
        }
        LOG.log(Level.FINE, "Launch Exe: {0}", StringUtils.join(result, (char)' '));
        return result;
    }

    @Override
    public CLRLaunchCommandBuilder setErrorHandlerRID(String errorHandlerRID) {
        this.errorHandlerRID = errorHandlerRID;
        return this;
    }

    @Override
    public CLRLaunchCommandBuilder setLaunchID(String launchID) {
        this.launchID = launchID;
        return this;
    }

    @Override
    public CLRLaunchCommandBuilder setMemory(int megaBytes) {
        this.megaBytes = megaBytes;
        return this;
    }

    @Override
    public CLRLaunchCommandBuilder setConfigurationFileName(String configurationFileName) {
        this.evaluatorConfigurationPath = configurationFileName;
        return this;
    }

    @Override
    public CLRLaunchCommandBuilder setStandardOut(String standardOut) {
        this.standardOutPath = standardOut;
        return this;
    }

    @Override
    public CLRLaunchCommandBuilder setStandardErr(String standardErr) {
        this.standardErrPath = standardErr;
        return this;
    }
}

