/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.files;

import java.io.File;
import javax.inject.Inject;
import net.jcip.annotations.Immutable;

@Immutable
public final class REEFFileNames {
    private static final String REEF_BASE_FOLDER = "reef";
    private static final String GLOBAL_FOLDER = "global";
    private static final String GLOBAL_FOLDER_PATH = "reef/global";
    private static final String LOCAL_FOLDER = "local";
    private static final String LOCAL_FOLDER_PATH = "reef/local";
    private static final String DRIVER_CONFIGURATION_NAME = "driver.conf";
    private static final String DRIVER_CONFIGURATION_PATH = "reef/local/driver.conf";
    private static final String EVALUATOR_CONFIGURATION_NAME = "evaluator.conf";
    private static final String EVALUATOR_CONFIGURATION_PATH = "reef/local/evaluator.conf";
    private static final String JAR_FILE_SUFFIX = ".jar";
    private static final String JOB_FOLDER_PREFIX = "reef-job-";
    private static final String EVALUATOR_FOLDER_PREFIX = "reef-evaluator-";
    private static final String DRIVER_STDERR = "driver.stderr";
    private static final String DRIVER_STDOUT = "driver.stdout";
    private static final String EVALUATOR_STDERR = "evaluator.stderr";
    private static final String EVALUATOR_STDOUT = "evaluator.stdout";
    @Deprecated
    private static final String REEF_DRIVER_APPDLL_DIR = "/ReefDriverAppDlls/";
    @Deprecated
    private static final String TMP_LOAD_DIR = "/reef/CLRLoadingDirectory";
    private static final String BRIDGE_DLL_NAME = "Org.Apache.REEF.Bridge.dll";

    @Inject
    public REEFFileNames() {
    }

    public String getBridgeDLLName() {
        return BRIDGE_DLL_NAME;
    }

    public File getBridgeDLLInLocalFolderFile() {
        return new File(this.getLocalFolder(), this.getBridgeDLLName());
    }

    public File getBridgeDLLInGlobalFolderFile() {
        return new File(this.getGlobalFolder(), this.getBridgeDLLName());
    }

    public String getREEFFolderName() {
        return REEF_BASE_FOLDER;
    }

    public File getREEFFolder() {
        return new File(this.getREEFFolderName());
    }

    public String getGlobalFolderName() {
        return GLOBAL_FOLDER;
    }

    public String getGlobalFolderPath() {
        return GLOBAL_FOLDER_PATH;
    }

    public File getGlobalFolder() {
        return new File(this.getREEFFolder(), this.getGlobalFolderName());
    }

    public String getLocalFolderName() {
        return LOCAL_FOLDER;
    }

    public String getLocalFolderPath() {
        return LOCAL_FOLDER_PATH;
    }

    public File getLocalFolder() {
        return new File(this.getREEFFolder(), this.getLocalFolderName());
    }

    public String getDriverConfigurationName() {
        return DRIVER_CONFIGURATION_NAME;
    }

    public String getDriverConfigurationPath() {
        return DRIVER_CONFIGURATION_PATH;
    }

    public String getEvaluatorConfigurationName() {
        return EVALUATOR_CONFIGURATION_NAME;
    }

    public String getEvaluatorConfigurationPath() {
        return EVALUATOR_CONFIGURATION_PATH;
    }

    public String getJarFileSuffix() {
        return JAR_FILE_SUFFIX;
    }

    public String getJobFolderPrefix() {
        return JOB_FOLDER_PREFIX;
    }

    public String getDriverStderrFileName() {
        return DRIVER_STDERR;
    }

    public String getDriverStdoutFileName() {
        return DRIVER_STDOUT;
    }

    public String getEvaluatorFolderPrefix() {
        return EVALUATOR_FOLDER_PREFIX;
    }

    public String getEvaluatorStderrFileName() {
        return EVALUATOR_STDERR;
    }

    public String getEvaluatorStdoutFileName() {
        return EVALUATOR_STDOUT;
    }

    @Deprecated
    public String getReefDriverAppDllDir() {
        return REEF_DRIVER_APPDLL_DIR;
    }

    @Deprecated
    public String getLoadDir() {
        return TMP_LOAD_DIR;
    }
}

