/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.files;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.ClientSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.annotations.audience.RuntimeAuthor;
import org.apache.reef.runtime.common.client.api.JobSubmissionEvent;
import org.apache.reef.runtime.common.files.FileResource;
import org.apache.reef.runtime.common.files.REEFFileNames;
import org.apache.reef.runtime.common.parameters.DeleteTempFiles;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.tang.formats.ConfigurationSerializer;
import org.apache.reef.util.JARFileMaker;

@Private
@RuntimeAuthor
@ClientSide
public final class JobJarMaker {
    private static final Logger LOG = Logger.getLogger(JobJarMaker.class.getName());
    private final ConfigurationSerializer configurationSerializer;
    private final REEFFileNames fileNames;
    private final boolean deleteTempFilesOnExit;

    @Inject
    JobJarMaker(ConfigurationSerializer configurationSerializer, REEFFileNames fileNames, @Parameter(value=DeleteTempFiles.class) boolean deleteTempFilesOnExit) {
        this.configurationSerializer = configurationSerializer;
        this.fileNames = fileNames;
        this.deleteTempFilesOnExit = deleteTempFilesOnExit;
    }

    public static void copy(Iterable<FileResource> files, File destinationFolder) {
        if (!destinationFolder.exists()) {
            destinationFolder.mkdirs();
        }
        for (FileResource fileProto : files) {
            File sourceFile = JobJarMaker.toFile(fileProto);
            File destinationFile = new File(destinationFolder, fileProto.getName());
            if (destinationFile.exists()) {
                LOG.log(Level.FINEST, "Will not add {0} to the job jar because another file with the same name was already added.", sourceFile.getAbsolutePath());
                continue;
            }
            try {
                Files.copy(sourceFile.toPath(), destinationFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                String message = "Copy of file [" + sourceFile.getAbsolutePath() + "] to [" + destinationFile.getAbsolutePath() + "] failed.";
                throw new RuntimeException(message, e);
            }
        }
    }

    private static File toFile(FileResource fileProto) {
        return new File(fileProto.getPath());
    }

    public File createJobSubmissionJAR(JobSubmissionEvent jobSubmissionEvent, Configuration driverConfiguration) throws IOException {
        File jobSubmissionFolder = this.makejobSubmissionFolder();
        LOG.log(Level.FINE, "Staging submission in {0}", jobSubmissionFolder);
        File localFolder = new File(jobSubmissionFolder, this.fileNames.getLocalFolderName());
        File globalFolder = new File(jobSubmissionFolder, this.fileNames.getGlobalFolderName());
        JobJarMaker.copy(jobSubmissionEvent.getGlobalFileSet(), globalFolder);
        JobJarMaker.copy(jobSubmissionEvent.getLocalFileSet(), localFolder);
        this.configurationSerializer.toFile(driverConfiguration, new File(localFolder, this.fileNames.getDriverConfigurationName()));
        File jarFile = File.createTempFile(this.fileNames.getJobFolderPrefix(), this.fileNames.getJarFileSuffix());
        LOG.log(Level.FINE, "Creating job submission jar file: {0}", jarFile);
        new JARFileMaker(jarFile).addChildren(jobSubmissionFolder).close();
        if (this.deleteTempFilesOnExit) {
            LOG.log(Level.FINE, "Deleting the temporary job folder [{0}] and marking the jar file [{1}] for deletion after the JVM exits.", new Object[]{jobSubmissionFolder.getAbsolutePath(), jarFile.getAbsolutePath()});
            jobSubmissionFolder.delete();
            jarFile.deleteOnExit();
        } else {
            LOG.log(Level.FINE, "Keeping the temporary job folder [{0}] and jar file [{1}] available after job submission.", new Object[]{jobSubmissionFolder.getAbsolutePath(), jarFile.getAbsolutePath()});
        }
        return jarFile;
    }

    private File makejobSubmissionFolder() throws IOException {
        return Files.createTempDirectory(this.fileNames.getJobFolderPrefix(), new FileAttribute[0]).toFile();
    }
}

