/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.files;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import net.jcip.annotations.Immutable;
import org.apache.reef.annotations.audience.RuntimeAuthor;
import org.apache.reef.runtime.common.files.REEFFileNames;
import org.apache.reef.runtime.common.files.RuntimeClasspathProvider;

@Immutable
@RuntimeAuthor
public final class ClasspathProvider {
    private final List<String> driverClasspath;
    private final List<String> evaluatorClasspath;

    @Inject
    ClasspathProvider(RuntimeClasspathProvider runtimeClasspathProvider, REEFFileNames reefFileNames) {
        List<String> baseClasspath = Arrays.asList(reefFileNames.getLocalFolderPath() + "/*", reefFileNames.getGlobalFolderPath() + "/*");
        List<String> runtimeDriverClasspathPrefix = runtimeClasspathProvider.getDriverClasspathPrefix();
        List<String> runtimeDriverClasspathSuffix = runtimeClasspathProvider.getDriverClasspathSuffix();
        ArrayList<String> driverClasspath = new ArrayList<String>(baseClasspath.size() + runtimeDriverClasspathPrefix.size() + runtimeDriverClasspathSuffix.size());
        driverClasspath.addAll(runtimeDriverClasspathPrefix);
        driverClasspath.addAll(baseClasspath);
        driverClasspath.addAll(runtimeDriverClasspathSuffix);
        this.driverClasspath = Collections.unmodifiableList(driverClasspath);
        List<String> runtimeEvaluatorClasspathPrefix = runtimeClasspathProvider.getEvaluatorClasspathPrefix();
        List<String> runtimeEvaluatorClasspathSuffix = runtimeClasspathProvider.getEvaluatorClasspathSuffix();
        ArrayList<String> evaluatorClasspath = new ArrayList<String>(runtimeEvaluatorClasspathPrefix.size() + baseClasspath.size() + runtimeEvaluatorClasspathSuffix.size());
        evaluatorClasspath.addAll(runtimeEvaluatorClasspathPrefix);
        evaluatorClasspath.addAll(baseClasspath);
        evaluatorClasspath.addAll(runtimeEvaluatorClasspathSuffix);
        this.evaluatorClasspath = Collections.unmodifiableList(evaluatorClasspath);
    }

    public List<String> getDriverClasspath() {
        return this.driverClasspath;
    }

    public List<String> getEvaluatorClasspath() {
        return this.evaluatorClasspath;
    }
}

