/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.evaluator.task;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.task.TaskConfigurationOptions;
import org.apache.reef.evaluator.context.parameters.ContextIdentifier;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.evaluator.HeartBeatManager;
import org.apache.reef.runtime.common.utils.ExceptionCodec;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.task.TaskMessage;
import org.apache.reef.task.TaskMessageSource;
import org.apache.reef.util.Optional;

public final class TaskStatus {
    private static final Logger LOG = Logger.getLogger(TaskStatus.class.getName());
    private final String taskId;
    private final String contextId;
    private final HeartBeatManager heartBeatManager;
    private final Set<TaskMessageSource> evaluatorMessageSources;
    private final ExceptionCodec exceptionCodec;
    private Optional<Throwable> lastException = Optional.empty();
    private Optional<byte[]> result = Optional.empty();
    private State state = State.PRE_INIT;

    @Inject
    TaskStatus(@Parameter(value=TaskConfigurationOptions.Identifier.class) String taskId, @Parameter(value=ContextIdentifier.class) String contextId, @Parameter(value=TaskConfigurationOptions.TaskMessageSources.class) Set<TaskMessageSource> evaluatorMessageSources, HeartBeatManager heartBeatManager, ExceptionCodec exceptionCodec) {
        this.taskId = taskId;
        this.contextId = contextId;
        this.heartBeatManager = heartBeatManager;
        this.evaluatorMessageSources = evaluatorMessageSources;
        this.exceptionCodec = exceptionCodec;
    }

    private static boolean isLegal(State from, State to) {
        if (from == null) {
            return to == State.INIT;
        }
        switch (from) {
            case PRE_INIT: {
                switch (to) {
                    case INIT: {
                        return true;
                    }
                }
                return false;
            }
            case INIT: {
                switch (to) {
                    case RUNNING: 
                    case FAILED: 
                    case KILLED: 
                    case DONE: {
                        return true;
                    }
                }
                return false;
            }
            case RUNNING: {
                switch (to) {
                    case FAILED: 
                    case KILLED: 
                    case DONE: 
                    case CLOSE_REQUESTED: 
                    case SUSPEND_REQUESTED: {
                        return true;
                    }
                }
                return false;
            }
            case CLOSE_REQUESTED: {
                switch (to) {
                    case FAILED: 
                    case KILLED: 
                    case DONE: {
                        return true;
                    }
                }
                return false;
            }
            case SUSPEND_REQUESTED: {
                switch (to) {
                    case FAILED: 
                    case KILLED: 
                    case SUSPENDED: {
                        return true;
                    }
                }
                return false;
            }
            case FAILED: 
            case KILLED: 
            case DONE: {
                return false;
            }
        }
        return false;
    }

    public final String getTaskId() {
        return this.taskId;
    }

    ReefServiceProtos.TaskStatusProto toProto() {
        this.check();
        ReefServiceProtos.TaskStatusProto.Builder result = ReefServiceProtos.TaskStatusProto.newBuilder().setContextId(this.contextId).setTaskId(this.taskId).setState(this.getProtoState());
        if (this.result.isPresent()) {
            result.setResult(ByteString.copyFrom((byte[])((byte[])this.result.get())));
        } else if (this.lastException.isPresent()) {
            byte[] error = this.exceptionCodec.toBytes((Throwable)this.lastException.get());
            result.setResult(ByteString.copyFrom((byte[])error));
        } else if (this.state == State.RUNNING) {
            for (TaskMessage taskMessage : this.getMessages()) {
                result.addTaskMessage(ReefServiceProtos.TaskStatusProto.TaskMessageProto.newBuilder().setSourceId(taskMessage.getMessageSourceID()).setMessage(ByteString.copyFrom((byte[])taskMessage.get())).build());
            }
        }
        return result.build();
    }

    private void check() {
        if (this.result.isPresent() && this.lastException.isPresent()) {
            throw new RuntimeException("Found both an exception and a result. This is unsupported.");
        }
    }

    private ReefServiceProtos.State getProtoState() {
        switch (this.state) {
            case INIT: {
                return ReefServiceProtos.State.INIT;
            }
            case RUNNING: 
            case CLOSE_REQUESTED: 
            case SUSPEND_REQUESTED: {
                return ReefServiceProtos.State.RUNNING;
            }
            case DONE: {
                return ReefServiceProtos.State.DONE;
            }
            case SUSPENDED: {
                return ReefServiceProtos.State.SUSPEND;
            }
            case FAILED: {
                return ReefServiceProtos.State.FAILED;
            }
            case KILLED: {
                return ReefServiceProtos.State.KILLED;
            }
        }
        throw new RuntimeException("Unknown state: " + (Object)((Object)this.state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setException(Throwable throwable) {
        HeartBeatManager heartBeatManager = this.heartBeatManager;
        synchronized (heartBeatManager) {
            this.lastException = Optional.of((Object)throwable);
            this.state = State.FAILED;
            this.check();
            this.heartbeat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setResult(byte[] result) {
        HeartBeatManager heartBeatManager = this.heartBeatManager;
        synchronized (heartBeatManager) {
            this.result = Optional.ofNullable((Object)result);
            if (this.state == State.RUNNING) {
                this.setState(State.DONE);
            } else if (this.state == State.SUSPEND_REQUESTED) {
                this.setState(State.SUSPENDED);
            } else if (this.state == State.CLOSE_REQUESTED) {
                this.setState(State.DONE);
            }
            this.check();
            this.heartbeat();
        }
    }

    private void heartbeat() {
        this.heartBeatManager.sendTaskStatus(this.toProto());
    }

    void setInit() {
        LOG.log(Level.FINEST, "Sending Task INIT heartbeat to the Driver.");
        this.setState(State.INIT);
        this.heartbeat();
    }

    void setRunning() {
        this.setState(State.RUNNING);
    }

    void setCloseRequested() {
        this.setState(State.CLOSE_REQUESTED);
    }

    void setSuspendRequested() {
        this.setState(State.SUSPEND_REQUESTED);
    }

    void setKilled() {
        this.setState(State.KILLED);
        this.heartbeat();
    }

    boolean isRunning() {
        return this.state == State.RUNNING;
    }

    boolean isNotRunning() {
        return this.state != State.RUNNING;
    }

    boolean hasEnded() {
        switch (this.state) {
            case FAILED: 
            case KILLED: 
            case DONE: 
            case SUSPENDED: {
                return true;
            }
        }
        return false;
    }

    State getState() {
        return this.state;
    }

    private void setState(State state) {
        if (!TaskStatus.isLegal(this.state, state)) {
            String msg = "Illegal state transition from [" + (Object)((Object)this.state) + "] to [" + (Object)((Object)state) + "]";
            LOG.log(Level.SEVERE, msg);
            throw new RuntimeException(msg);
        }
        this.state = state;
    }

    String getContextId() {
        return this.contextId;
    }

    private final Collection<TaskMessage> getMessages() {
        ArrayList<TaskMessage> result = new ArrayList<TaskMessage>(this.evaluatorMessageSources.size());
        for (TaskMessageSource messageSource : this.evaluatorMessageSources) {
            Optional<TaskMessage> taskMessageOptional = messageSource.getMessage();
            if (!taskMessageOptional.isPresent()) continue;
            result.add((TaskMessage)taskMessageOptional.get());
        }
        return result;
    }

    static enum State {
        PRE_INIT,
        INIT,
        RUNNING,
        CLOSE_REQUESTED,
        SUSPEND_REQUESTED,
        SUSPENDED,
        FAILED,
        DONE,
        KILLED;

    }
}

