/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.evaluator.task;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.xml.bind.DatatypeConverter;
import org.apache.reef.annotations.audience.EvaluatorSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.driver.task.TaskConfigurationOptions;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.evaluator.HeartBeatManager;
import org.apache.reef.runtime.common.evaluator.task.CloseEventImpl;
import org.apache.reef.runtime.common.evaluator.task.DriverMessageImpl;
import org.apache.reef.runtime.common.evaluator.task.SuspendEventImpl;
import org.apache.reef.runtime.common.evaluator.task.TaskLifeCycleHandlers;
import org.apache.reef.runtime.common.evaluator.task.TaskStatus;
import org.apache.reef.runtime.common.evaluator.task.exceptions.TaskCallFailure;
import org.apache.reef.runtime.common.evaluator.task.exceptions.TaskCloseHandlerFailure;
import org.apache.reef.runtime.common.evaluator.task.exceptions.TaskMessageHandlerFailure;
import org.apache.reef.runtime.common.evaluator.task.exceptions.TaskStartHandlerFailure;
import org.apache.reef.runtime.common.evaluator.task.exceptions.TaskStopHandlerFailure;
import org.apache.reef.runtime.common.evaluator.task.exceptions.TaskSuspendHandlerFailure;
import org.apache.reef.tang.InjectionFuture;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.task.Task;
import org.apache.reef.task.events.CloseEvent;
import org.apache.reef.task.events.DriverMessage;
import org.apache.reef.task.events.SuspendEvent;
import org.apache.reef.util.Optional;
import org.apache.reef.wake.EventHandler;

@Private
@EvaluatorSide
public final class TaskRuntime
implements Runnable {
    private static final Logger LOG = Logger.getLogger(TaskRuntime.class.getName());
    private final Task task;
    private final InjectionFuture<EventHandler<CloseEvent>> f_closeHandler;
    private final InjectionFuture<EventHandler<SuspendEvent>> f_suspendHandler;
    private final InjectionFuture<EventHandler<DriverMessage>> f_messageHandler;
    private final TaskLifeCycleHandlers taskLifeCycleHandlers;
    private final Optional<byte[]> memento;
    private final HeartBeatManager heartBeatManager;
    private final TaskStatus currentStatus;

    @Inject
    private TaskRuntime(HeartBeatManager heartBeatManager, Task task, TaskStatus currentStatus, @Parameter(value=TaskConfigurationOptions.CloseHandler.class) InjectionFuture<EventHandler<CloseEvent>> f_closeHandler, @Parameter(value=TaskConfigurationOptions.SuspendHandler.class) InjectionFuture<EventHandler<SuspendEvent>> f_suspendHandler, @Parameter(value=TaskConfigurationOptions.MessageHandler.class) InjectionFuture<EventHandler<DriverMessage>> f_messageHandler, TaskLifeCycleHandlers taskLifeCycleHandlers) {
        this(heartBeatManager, task, currentStatus, f_closeHandler, f_suspendHandler, f_messageHandler, null, taskLifeCycleHandlers);
    }

    @Inject
    private TaskRuntime(HeartBeatManager heartBeatManager, Task task, TaskStatus currentStatus, @Parameter(value=TaskConfigurationOptions.CloseHandler.class) InjectionFuture<EventHandler<CloseEvent>> f_closeHandler, @Parameter(value=TaskConfigurationOptions.SuspendHandler.class) InjectionFuture<EventHandler<SuspendEvent>> f_suspendHandler, @Parameter(value=TaskConfigurationOptions.MessageHandler.class) InjectionFuture<EventHandler<DriverMessage>> f_messageHandler, @Parameter(value=TaskConfigurationOptions.Memento.class) String memento, TaskLifeCycleHandlers taskLifeCycleHandlers) {
        this.heartBeatManager = heartBeatManager;
        this.task = task;
        this.taskLifeCycleHandlers = taskLifeCycleHandlers;
        this.memento = null == memento ? Optional.empty() : Optional.of((Object)DatatypeConverter.parseBase64Binary((String)memento));
        this.f_closeHandler = f_closeHandler;
        this.f_suspendHandler = f_suspendHandler;
        this.f_messageHandler = f_messageHandler;
        this.currentStatus = currentStatus;
    }

    public void initialize() {
        this.currentStatus.setInit();
    }

    @Override
    public void run() {
        try {
            this.taskLifeCycleHandlers.beforeTaskStart();
            LOG.log(Level.FINEST, "Informing registered EventHandler<TaskStart>.");
            this.currentStatus.setRunning();
            byte[] result = this.runTask();
            this.currentStatus.setResult(result);
            LOG.log(Level.FINEST, "Informing registered EventHandler<TaskStop>.");
            this.taskLifeCycleHandlers.afterTaskExit();
        }
        catch (TaskStartHandlerFailure taskStartHandlerFailure) {
            LOG.log(Level.WARNING, "Caught an exception during TaskStart handler execution.", taskStartHandlerFailure);
            this.currentStatus.setException(taskStartHandlerFailure.getCause());
        }
        catch (TaskStopHandlerFailure taskStopHandlerFailure) {
            LOG.log(Level.WARNING, "Caught an exception during TaskStop handler execution.", taskStopHandlerFailure);
            this.currentStatus.setException(taskStopHandlerFailure.getCause());
        }
        catch (TaskCallFailure e) {
            LOG.log(Level.WARNING, "Caught an exception during Task.call().", e.getCause());
            this.currentStatus.setException(e);
        }
    }

    public ReefServiceProtos.TaskStatusProto getStatusProto() {
        return this.currentStatus.toProto();
    }

    public boolean hasEnded() {
        return this.currentStatus.hasEnded();
    }

    public String getTaskId() {
        return this.currentStatus.getTaskId();
    }

    public String getId() {
        return "TASK:" + this.task.getClass().getSimpleName() + ':' + this.currentStatus.getTaskId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(byte[] message) {
        LOG.log(Level.FINEST, "Triggering Task close.");
        HeartBeatManager heartBeatManager = this.heartBeatManager;
        synchronized (heartBeatManager) {
            if (this.currentStatus.isNotRunning()) {
                LOG.log(Level.WARNING, "Trying to close a task that is in state: {0}. Ignoring.", (Object)this.currentStatus.getState());
            } else {
                try {
                    this.closeTask(message);
                    this.currentStatus.setCloseRequested();
                }
                catch (TaskCloseHandlerFailure taskCloseHandlerFailure) {
                    LOG.log(Level.WARNING, "Exception while executing task close handler.", taskCloseHandlerFailure.getCause());
                    this.currentStatus.setException(taskCloseHandlerFailure.getCause());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(byte[] message) {
        HeartBeatManager heartBeatManager = this.heartBeatManager;
        synchronized (heartBeatManager) {
            if (this.currentStatus.isNotRunning()) {
                LOG.log(Level.WARNING, "Trying to suspend a task that is in state: {0}. Ignoring.", (Object)this.currentStatus.getState());
            } else {
                try {
                    this.suspendTask(message);
                    this.currentStatus.setSuspendRequested();
                }
                catch (TaskSuspendHandlerFailure taskSuspendHandlerFailure) {
                    LOG.log(Level.WARNING, "Exception while executing task suspend handler.", taskSuspendHandlerFailure.getCause());
                    this.currentStatus.setException(taskSuspendHandlerFailure.getCause());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(byte[] message) {
        HeartBeatManager heartBeatManager = this.heartBeatManager;
        synchronized (heartBeatManager) {
            if (this.currentStatus.isNotRunning()) {
                LOG.log(Level.WARNING, "Trying to send a message to a task that is in state: {0}. Ignoring.", (Object)this.currentStatus.getState());
            } else {
                try {
                    this.deliverMessageToTask(message);
                }
                catch (TaskMessageHandlerFailure taskMessageHandlerFailure) {
                    LOG.log(Level.WARNING, "Exception while executing task close handler.", taskMessageHandlerFailure.getCause());
                    this.currentStatus.setException(taskMessageHandlerFailure.getCause());
                }
            }
        }
    }

    private String getContextID() {
        return this.currentStatus.getContextId();
    }

    private byte[] runTask() throws TaskCallFailure {
        try {
            byte[] result;
            if (this.memento.isPresent()) {
                LOG.log(Level.FINEST, "Calling Task.call() with a memento");
                result = this.task.call((byte[])this.memento.get());
            } else {
                LOG.log(Level.FINEST, "Calling Task.call() without a memento");
                result = this.task.call(null);
            }
            LOG.log(Level.FINEST, "Task.call() exited cleanly.");
            return result;
        }
        catch (Throwable throwable) {
            throw new TaskCallFailure(throwable);
        }
    }

    private void closeTask(byte[] message) throws TaskCloseHandlerFailure {
        LOG.log(Level.FINEST, "Invoking close handler.");
        try {
            ((EventHandler)this.f_closeHandler.get()).onNext((Object)new CloseEventImpl(message));
        }
        catch (Throwable throwable) {
            throw new TaskCloseHandlerFailure(throwable);
        }
    }

    private void deliverMessageToTask(byte[] message) throws TaskMessageHandlerFailure {
        try {
            ((EventHandler)this.f_messageHandler.get()).onNext((Object)new DriverMessageImpl(message));
        }
        catch (Throwable throwable) {
            throw new TaskMessageHandlerFailure(throwable);
        }
    }

    private void suspendTask(byte[] message) throws TaskSuspendHandlerFailure {
        try {
            ((EventHandler)this.f_suspendHandler.get()).onNext((Object)new SuspendEventImpl(message));
        }
        catch (Throwable throwable) {
            throw new TaskSuspendHandlerFailure(throwable);
        }
    }
}

