/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.evaluator.task;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.EvaluatorSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.driver.task.TaskConfigurationOptions;
import org.apache.reef.runtime.common.evaluator.task.TaskStartImpl;
import org.apache.reef.runtime.common.evaluator.task.TaskStopImpl;
import org.apache.reef.runtime.common.evaluator.task.exceptions.TaskStartHandlerFailure;
import org.apache.reef.runtime.common.evaluator.task.exceptions.TaskStopHandlerFailure;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.task.events.TaskStart;
import org.apache.reef.task.events.TaskStop;
import org.apache.reef.wake.EventHandler;

@EvaluatorSide
@Private
final class TaskLifeCycleHandlers {
    private static final Logger LOG = Logger.getLogger(TaskLifeCycleHandlers.class.getName());
    private final Set<EventHandler<TaskStop>> taskStopHandlers;
    private final Set<EventHandler<TaskStart>> taskStartHandlers;
    private final TaskStart taskStart;
    private final TaskStop taskStop;

    @Inject
    TaskLifeCycleHandlers(@Parameter(value=TaskConfigurationOptions.StopHandlers.class) Set<EventHandler<TaskStop>> taskStopHandlers, @Parameter(value=TaskConfigurationOptions.StartHandlers.class) Set<EventHandler<TaskStart>> taskStartHandlers, TaskStartImpl taskStart, TaskStopImpl taskStop) {
        this.taskStopHandlers = taskStopHandlers;
        this.taskStartHandlers = taskStartHandlers;
        this.taskStart = taskStart;
        this.taskStop = taskStop;
    }

    public void beforeTaskStart() throws TaskStartHandlerFailure {
        LOG.log(Level.FINEST, "Sending TaskStart event to the registered event handlers.");
        for (EventHandler<TaskStart> startHandler : this.taskStartHandlers) {
            try {
                startHandler.onNext((Object)this.taskStart);
            }
            catch (Throwable throwable) {
                throw new TaskStartHandlerFailure(startHandler, throwable);
            }
        }
        LOG.log(Level.FINEST, "Done sending TaskStart event to the registered event handlers.");
    }

    public void afterTaskExit() throws TaskStopHandlerFailure {
        LOG.log(Level.FINEST, "Sending TaskStop event to the registered event handlers.");
        for (EventHandler<TaskStop> stopHandler : this.taskStopHandlers) {
            try {
                stopHandler.onNext((Object)this.taskStop);
            }
            catch (Throwable throwable) {
                throw new TaskStopHandlerFailure(stopHandler, throwable);
            }
        }
        LOG.log(Level.FINEST, "Done sending TaskStop event to the registered event handlers.");
    }
}

