/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.evaluator.task;

import org.apache.reef.driver.task.TaskConfigurationOptions;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.exceptions.InjectionException;

public final class TaskClientCodeException
extends Exception {
    private final String taskId;
    private final String contextId;

    public TaskClientCodeException(String taskId, String contextId, String message, Throwable cause) {
        super("Failure in task '" + taskId + "' in context '" + contextId + "': " + message, cause);
        this.taskId = taskId;
        this.contextId = contextId;
    }

    public static String getTaskId(Configuration config) {
        try {
            return (String)Tang.Factory.getTang().newInjector(config).getNamedInstance(TaskConfigurationOptions.Identifier.class);
        }
        catch (InjectionException ex) {
            throw new RuntimeException("Unable to determine task identifier. Giving up.", ex);
        }
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getContextId() {
        return this.contextId;
    }
}

