/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.evaluator.context;

import java.io.IOException;
import javax.inject.Inject;
import org.apache.reef.runtime.common.evaluator.context.ContextClientCodeException;
import org.apache.reef.runtime.common.evaluator.context.ContextRuntime;
import org.apache.reef.runtime.common.evaluator.parameters.InitialTaskConfiguration;
import org.apache.reef.runtime.common.evaluator.parameters.RootContextConfiguration;
import org.apache.reef.runtime.common.evaluator.parameters.RootServiceConfiguration;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Injector;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.formats.ConfigurationSerializer;
import org.apache.reef.util.Optional;

final class RootContextLauncher {
    private final Injector injector;
    private final Configuration rootContextConfiguration;
    private final Optional<Configuration> rootServiceConfiguration;
    private final Optional<Configuration> initialTaskConfiguration;
    private final ConfigurationSerializer configurationSerializer;
    private ContextRuntime rootContext = null;

    @Inject
    RootContextLauncher(@Parameter(value=RootContextConfiguration.class) String rootContextConfiguration, @Parameter(value=RootServiceConfiguration.class) String rootServiceConfiguration, @Parameter(value=InitialTaskConfiguration.class) String initialTaskConfiguration, Injector injector, ConfigurationSerializer configurationSerializer) throws IOException, BindException {
        this.injector = injector;
        this.configurationSerializer = configurationSerializer;
        this.rootContextConfiguration = this.configurationSerializer.fromString(rootContextConfiguration);
        this.rootServiceConfiguration = Optional.of((Object)this.configurationSerializer.fromString(rootServiceConfiguration));
        this.initialTaskConfiguration = Optional.of((Object)this.configurationSerializer.fromString(initialTaskConfiguration));
    }

    @Inject
    RootContextLauncher(@Parameter(value=RootContextConfiguration.class) String rootContextConfiguration, Injector injector, @Parameter(value=RootServiceConfiguration.class) String rootServiceConfiguration, ConfigurationSerializer configurationSerializer) throws IOException, BindException {
        this.injector = injector;
        this.configurationSerializer = configurationSerializer;
        this.rootContextConfiguration = this.configurationSerializer.fromString(rootContextConfiguration);
        this.rootServiceConfiguration = Optional.of((Object)this.configurationSerializer.fromString(rootServiceConfiguration));
        this.initialTaskConfiguration = Optional.empty();
    }

    @Inject
    RootContextLauncher(Injector injector, @Parameter(value=RootContextConfiguration.class) String rootContextConfiguration, @Parameter(value=InitialTaskConfiguration.class) String initialTaskConfiguration, ConfigurationSerializer configurationSerializer) throws IOException, BindException {
        this.injector = injector;
        this.configurationSerializer = configurationSerializer;
        this.rootContextConfiguration = this.configurationSerializer.fromString(rootContextConfiguration);
        this.rootServiceConfiguration = Optional.empty();
        this.initialTaskConfiguration = Optional.of((Object)this.configurationSerializer.fromString(initialTaskConfiguration));
    }

    @Inject
    RootContextLauncher(@Parameter(value=RootContextConfiguration.class) String rootContextConfiguration, Injector injector, ConfigurationSerializer configurationSerializer) throws IOException, BindException {
        this.injector = injector;
        this.configurationSerializer = configurationSerializer;
        this.rootContextConfiguration = this.configurationSerializer.fromString(rootContextConfiguration);
        this.rootServiceConfiguration = Optional.empty();
        this.initialTaskConfiguration = Optional.empty();
    }

    private static ContextRuntime getRootContext(Injector injector, Configuration rootContextConfiguration, Optional<Configuration> rootServiceConfiguration) throws ContextClientCodeException {
        ContextRuntime result;
        if (rootServiceConfiguration.isPresent()) {
            Injector rootServiceInjector;
            try {
                rootServiceInjector = injector.forkInjector(new Configuration[]{(Configuration)rootServiceConfiguration.get()});
            }
            catch (BindException e) {
                throw new ContextClientCodeException(ContextClientCodeException.getIdentifier(rootContextConfiguration), (Optional<String>)Optional.empty(), "Unable to instatiate the root context", e);
            }
            result = new ContextRuntime(rootServiceInjector, rootContextConfiguration);
        } else {
            result = new ContextRuntime(injector.forkInjector(), rootContextConfiguration);
        }
        return result;
    }

    final ContextRuntime getRootContext() throws ContextClientCodeException {
        if (null == this.rootContext) {
            this.rootContext = RootContextLauncher.getRootContext(this.injector, this.rootContextConfiguration, this.rootServiceConfiguration);
        }
        return this.rootContext;
    }

    final Optional<Configuration> getInitialTaskConfiguration() {
        return this.initialTaskConfiguration;
    }
}

