/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.evaluator.context;

import com.google.protobuf.ByteString;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.annotations.Provided;
import org.apache.reef.annotations.audience.EvaluatorSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.evaluator.context.ContextMessage;
import org.apache.reef.evaluator.context.ContextMessageSource;
import org.apache.reef.evaluator.context.parameters.Services;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.evaluator.context.ContextClientCodeException;
import org.apache.reef.runtime.common.evaluator.context.ContextLifeCycle;
import org.apache.reef.runtime.common.evaluator.task.TaskClientCodeException;
import org.apache.reef.runtime.common.evaluator.task.TaskRuntime;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Injector;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.util.Optional;

@Provided
@Private
@EvaluatorSide
public final class ContextRuntime {
    private static final Logger LOG = Logger.getLogger(ContextRuntime.class.getName());
    private final Injector contextInjector;
    private final Injector serviceInjector;
    private final ContextLifeCycle contextLifeCycle;
    private final Optional<ContextRuntime> parentContext;
    private Optional<ContextRuntime> childContext = Optional.empty();
    private Optional<TaskRuntime> task = Optional.empty();
    private Thread taskRuntimeThread = null;
    private ReefServiceProtos.ContextStatusProto.State contextState = ReefServiceProtos.ContextStatusProto.State.READY;

    ContextRuntime(Injector serviceInjector, Configuration contextConfiguration, Optional<ContextRuntime> parentContext) throws ContextClientCodeException {
        this.serviceInjector = serviceInjector;
        this.parentContext = parentContext;
        try {
            Set services = (Set)serviceInjector.getNamedInstance(Services.class);
            this.contextInjector = serviceInjector.forkInjector(new Configuration[]{contextConfiguration});
            this.contextLifeCycle = (ContextLifeCycle)this.contextInjector.getInstance(ContextLifeCycle.class);
        }
        catch (BindException | InjectionException e) {
            Optional parentID = this.getParentContext().isPresent() ? Optional.of((Object)((ContextRuntime)this.getParentContext().get()).getIdentifier()) : Optional.empty();
            throw new ContextClientCodeException(ContextClientCodeException.getIdentifier(contextConfiguration), (Optional<String>)parentID, "Unable to spawn context", e);
        }
        this.contextLifeCycle.start();
    }

    ContextRuntime(Injector serviceInjector, Configuration contextConfiguration) throws ContextClientCodeException {
        this(serviceInjector, contextConfiguration, (Optional<ContextRuntime>)Optional.empty());
        LOG.log(Level.FINEST, "Instantiating root context");
    }

    ContextRuntime spawnChildContext(Configuration contextConfiguration, Configuration serviceConfiguration) throws ContextClientCodeException {
        ContextLifeCycle contextLifeCycle = this.contextLifeCycle;
        synchronized (contextLifeCycle) {
            if (this.task.isPresent()) {
                throw new IllegalStateException("Attempting to spawn a child context when a Task with id '" + ((TaskRuntime)this.task.get()).getId() + "' is running.");
            }
            if (this.childContext.isPresent()) {
                throw new IllegalStateException("Attempting to instantiate a child context on a context that is not the topmost active context");
            }
            try {
                Injector childServiceInjector = this.serviceInjector.forkInjector(new Configuration[]{serviceConfiguration});
                ContextRuntime childContext = new ContextRuntime(childServiceInjector, contextConfiguration, (Optional<ContextRuntime>)Optional.of((Object)this));
                this.childContext = Optional.of((Object)childContext);
                return childContext;
            }
            catch (BindException e) {
                Optional parentID = this.getParentContext().isPresent() ? Optional.of((Object)((ContextRuntime)this.getParentContext().get()).getIdentifier()) : Optional.empty();
                throw new ContextClientCodeException(ContextClientCodeException.getIdentifier(contextConfiguration), (Optional<String>)parentID, "Unable to spawn context", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContextRuntime spawnChildContext(Configuration contextConfiguration) throws ContextClientCodeException {
        ContextLifeCycle contextLifeCycle = this.contextLifeCycle;
        synchronized (contextLifeCycle) {
            if (this.task.isPresent()) {
                throw new IllegalStateException("Attempting to to spawn a child context while a Task with id '" + ((TaskRuntime)this.task.get()).getId() + "' is running.");
            }
            if (this.childContext.isPresent()) {
                throw new IllegalStateException("Attempting to spawn a child context on a context that is not the topmost active context");
            }
            Injector childServiceInjector = this.serviceInjector.forkInjector();
            ContextRuntime childContext = new ContextRuntime(childServiceInjector, contextConfiguration, (Optional<ContextRuntime>)Optional.of((Object)this));
            this.childContext = Optional.of((Object)childContext);
            return childContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTask(Configuration taskConfig) throws TaskClientCodeException {
        ContextLifeCycle contextLifeCycle = this.contextLifeCycle;
        synchronized (contextLifeCycle) {
            if (this.task.isPresent() && ((TaskRuntime)this.task.get()).hasEnded()) {
                this.task = Optional.empty();
            }
            if (this.task.isPresent()) {
                throw new IllegalStateException("Attempting to start a Task when a Task with id '" + ((TaskRuntime)this.task.get()).getId() + "' is running.");
            }
            if (this.childContext.isPresent()) {
                throw new IllegalStateException("Attempting to start a Task on a context that is not the topmost active context");
            }
            try {
                Injector taskInjector = this.contextInjector.forkInjector(new Configuration[]{taskConfig});
                TaskRuntime taskRuntime = (TaskRuntime)taskInjector.getInstance(TaskRuntime.class);
                taskRuntime.initialize();
                this.taskRuntimeThread = new Thread((Runnable)taskRuntime, taskRuntime.getId());
                this.taskRuntimeThread.start();
                this.task = Optional.of((Object)taskRuntime);
                LOG.log(Level.FINEST, "Started task: {0}", taskRuntime.getTaskId());
            }
            catch (BindException | InjectionException e) {
                throw new TaskClientCodeException(TaskClientCodeException.getTaskId(taskConfig), this.getIdentifier(), "Unable to instantiate the new task", e);
            }
            catch (Throwable t) {
                throw new TaskClientCodeException(TaskClientCodeException.getTaskId(taskConfig), this.getIdentifier(), "Unable to start the new task", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() {
        ContextLifeCycle contextLifeCycle = this.contextLifeCycle;
        synchronized (contextLifeCycle) {
            this.contextState = ReefServiceProtos.ContextStatusProto.State.DONE;
            if (this.task.isPresent()) {
                LOG.log(Level.WARNING, "Shutting down a task because the underlying context is being closed.");
                ((TaskRuntime)this.task.get()).close(null);
            }
            if (this.childContext.isPresent()) {
                LOG.log(Level.WARNING, "Closing a context because its parent context is being closed.");
                ((ContextRuntime)this.childContext.get()).close();
            }
            this.contextLifeCycle.close();
            if (this.parentContext.isPresent()) {
                ((ContextRuntime)this.parentContext.get()).resetChildContext();
            }
        }
    }

    Optional<ContextRuntime> getParentContext() {
        return this.parentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void suspendTask(byte[] message) {
        ContextLifeCycle contextLifeCycle = this.contextLifeCycle;
        synchronized (contextLifeCycle) {
            if (!this.task.isPresent()) {
                LOG.log(Level.WARNING, "Received a suspend task while there was no task running. Ignoring.");
            } else {
                ((TaskRuntime)this.task.get()).suspend(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeTask(byte[] message) {
        ContextLifeCycle contextLifeCycle = this.contextLifeCycle;
        synchronized (contextLifeCycle) {
            if (!this.task.isPresent()) {
                LOG.log(Level.WARNING, "Received a close task while there was no task running. Ignoring.");
            } else {
                ((TaskRuntime)this.task.get()).close(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliverTaskMessage(byte[] message) {
        ContextLifeCycle contextLifeCycle = this.contextLifeCycle;
        synchronized (contextLifeCycle) {
            if (!this.task.isPresent()) {
                LOG.log(Level.WARNING, "Received a task message while there was no task running. Ignoring.");
            } else {
                ((TaskRuntime)this.task.get()).deliver(message);
            }
        }
    }

    String getIdentifier() {
        return this.contextLifeCycle.getIdentifier();
    }

    final void handleContextMessage(byte[] message) {
        this.contextLifeCycle.handleContextMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<ReefServiceProtos.TaskStatusProto> getTaskStatus() {
        ContextLifeCycle contextLifeCycle = this.contextLifeCycle;
        synchronized (contextLifeCycle) {
            if (this.task.isPresent()) {
                if (((TaskRuntime)this.task.get()).hasEnded()) {
                    this.task = Optional.empty();
                    return Optional.empty();
                }
                return Optional.of((Object)((TaskRuntime)this.task.get()).getStatusProto());
            }
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetChildContext() {
        ContextLifeCycle contextLifeCycle = this.contextLifeCycle;
        synchronized (contextLifeCycle) {
            if (!this.childContext.isPresent()) {
                throw new IllegalStateException("no child context set");
            }
            this.childContext = Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReefServiceProtos.ContextStatusProto getContextStatus() {
        ContextLifeCycle contextLifeCycle = this.contextLifeCycle;
        synchronized (contextLifeCycle) {
            ReefServiceProtos.ContextStatusProto.Builder builder = ReefServiceProtos.ContextStatusProto.newBuilder().setContextId(this.getIdentifier()).setContextState(this.contextState);
            if (this.parentContext.isPresent()) {
                builder.setParentId(((ContextRuntime)this.parentContext.get()).getIdentifier());
            }
            for (ContextMessageSource contextMessageSource : this.contextLifeCycle.getContextMessageSources()) {
                Optional<ContextMessage> contextMessageOptional = contextMessageSource.getMessage();
                if (!contextMessageOptional.isPresent()) continue;
                builder.addContextMessage(ReefServiceProtos.ContextStatusProto.ContextMessageProto.newBuilder().setSourceId(((ContextMessage)contextMessageOptional.get()).getMessageSourceID()).setMessage(ByteString.copyFrom((byte[])((ContextMessage)contextMessageOptional.get()).get())).build());
            }
            return builder.build();
        }
    }
}

