/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.evaluator.context;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.Provided;
import org.apache.reef.annotations.audience.EvaluatorSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.proto.EvaluatorRuntimeProtocol;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.evaluator.HeartBeatManager;
import org.apache.reef.runtime.common.evaluator.context.ContextClientCodeException;
import org.apache.reef.runtime.common.evaluator.context.ContextRuntime;
import org.apache.reef.runtime.common.evaluator.context.RootContextLauncher;
import org.apache.reef.runtime.common.evaluator.task.TaskClientCodeException;
import org.apache.reef.runtime.common.utils.ExceptionCodec;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.InjectionFuture;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.formats.ConfigurationSerializer;
import org.apache.reef.util.Optional;

@Private
@EvaluatorSide
@Provided
public final class ContextManager
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(ContextManager.class.getName());
    private final Stack<ContextRuntime> contextStack = new Stack();
    private final InjectionFuture<RootContextLauncher> launchContext;
    private final HeartBeatManager heartBeatManager;
    private final ConfigurationSerializer configurationSerializer;
    private final ExceptionCodec exceptionCodec;

    @Inject
    ContextManager(InjectionFuture<RootContextLauncher> launchContext, HeartBeatManager heartBeatManager, ConfigurationSerializer configurationSerializer, ExceptionCodec exceptionCodec) {
        this.launchContext = launchContext;
        this.heartBeatManager = heartBeatManager;
        this.configurationSerializer = configurationSerializer;
        this.exceptionCodec = exceptionCodec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ContextClientCodeException {
        Stack<ContextRuntime> stack = this.contextStack;
        synchronized (stack) {
            LOG.log(Level.FINEST, "Instantiating root context.");
            this.contextStack.push(((RootContextLauncher)this.launchContext.get()).getRootContext());
            if (((RootContextLauncher)this.launchContext.get()).getInitialTaskConfiguration().isPresent()) {
                LOG.log(Level.FINEST, "Launching the initial Task");
                try {
                    this.contextStack.peek().startTask((Configuration)((RootContextLauncher)this.launchContext.get()).getInitialTaskConfiguration().get());
                }
                catch (TaskClientCodeException e) {
                    this.handleTaskException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Stack<ContextRuntime> stack = this.contextStack;
        synchronized (stack) {
            if (!this.contextStackIsEmpty()) {
                ((ContextRuntime)this.contextStack.lastElement()).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contextStackIsEmpty() {
        Stack<ContextRuntime> stack = this.contextStack;
        synchronized (stack) {
            return this.contextStack.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleContextControlProtocol(EvaluatorRuntimeProtocol.ContextControlProto controlMessage) {
        HeartBeatManager heartBeatManager = this.heartBeatManager;
        synchronized (heartBeatManager) {
            block18: {
                try {
                    byte[] message;
                    if (controlMessage.hasAddContext() && controlMessage.hasRemoveContext()) {
                        throw new IllegalArgumentException("Received a message with both add and remove context. This is unsupported.");
                    }
                    byte[] byArray = message = controlMessage.hasTaskMessage() ? controlMessage.getTaskMessage().toByteArray() : null;
                    if (controlMessage.hasAddContext()) {
                        this.addContext(controlMessage.getAddContext());
                        if (controlMessage.hasStartTask()) {
                            this.startTask(controlMessage.getStartTask());
                        } else {
                            this.heartBeatManager.sendHeartbeat();
                        }
                        break block18;
                    }
                    if (controlMessage.hasRemoveContext()) {
                        this.removeContext(controlMessage.getRemoveContext().getContextId());
                        break block18;
                    }
                    if (controlMessage.hasStartTask()) {
                        this.startTask(controlMessage.getStartTask());
                        break block18;
                    }
                    if (controlMessage.hasStopTask()) {
                        this.contextStack.peek().closeTask(message);
                        break block18;
                    }
                    if (controlMessage.hasSuspendTask()) {
                        this.contextStack.peek().suspendTask(message);
                        break block18;
                    }
                    if (controlMessage.hasTaskMessage()) {
                        this.contextStack.peek().deliverTaskMessage(message);
                        break block18;
                    }
                    if (controlMessage.hasContextMessage()) {
                        EvaluatorRuntimeProtocol.ContextMessageProto contextMessageProto = controlMessage.getContextMessage();
                        boolean deliveredMessage = false;
                        for (ContextRuntime context : this.contextStack) {
                            if (!context.getIdentifier().equals(contextMessageProto.getContextId())) continue;
                            context.handleContextMessage(contextMessageProto.getMessage().toByteArray());
                            deliveredMessage = true;
                            break;
                        }
                        if (!deliveredMessage) {
                            throw new IllegalStateException("Sent message to unknown context " + contextMessageProto.getContextId());
                        }
                        break block18;
                    }
                    throw new RuntimeException("Unknown task control message: " + controlMessage);
                }
                catch (TaskClientCodeException e) {
                    this.handleTaskException(e);
                }
                catch (ContextClientCodeException e) {
                    this.handleContextException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ReefServiceProtos.TaskStatusProto> getTaskStatus() {
        Stack<ContextRuntime> stack = this.contextStack;
        synchronized (stack) {
            if (this.contextStack.isEmpty()) {
                throw new RuntimeException("Asked for a Task status while there isn't even a context running.");
            }
            return this.contextStack.peek().getTaskStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ReefServiceProtos.ContextStatusProto> getContextStatusCollection() {
        Stack<ContextRuntime> stack = this.contextStack;
        synchronized (stack) {
            ArrayList<ReefServiceProtos.ContextStatusProto> result = new ArrayList<ReefServiceProtos.ContextStatusProto>(this.contextStack.size());
            for (ContextRuntime contextRuntime : this.contextStack) {
                ReefServiceProtos.ContextStatusProto contextStatusProto = contextRuntime.getContextStatus();
                LOG.log(Level.FINEST, "Add context status: {0}", contextStatusProto);
                result.add(contextStatusProto);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addContext(EvaluatorRuntimeProtocol.AddContextProto addContextProto) throws ContextClientCodeException {
        Stack<ContextRuntime> stack = this.contextStack;
        synchronized (stack) {
            try {
                ContextRuntime currentTopContext = this.contextStack.peek();
                if (!currentTopContext.getIdentifier().equals(addContextProto.getParentContextId())) {
                    throw new IllegalStateException("Trying to instantiate a child context on context with id `" + addContextProto.getParentContextId() + "` while the current top context id is `" + currentTopContext.getIdentifier() + "`");
                }
                Configuration contextConfiguration = this.configurationSerializer.fromString(addContextProto.getContextConfiguration());
                ContextRuntime newTopContext = addContextProto.hasServiceConfiguration() ? currentTopContext.spawnChildContext(contextConfiguration, this.configurationSerializer.fromString(addContextProto.getServiceConfiguration())) : currentTopContext.spawnChildContext(contextConfiguration);
                this.contextStack.push(newTopContext);
            }
            catch (IOException | BindException e) {
                throw new RuntimeException("Unable to read configuration.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeContext(String contextID) {
        Stack<ContextRuntime> stack = this.contextStack;
        synchronized (stack) {
            if (!contextID.equals(this.contextStack.peek().getIdentifier())) {
                throw new IllegalStateException("Trying to close context with id `" + contextID + "`. But the top context has id `" + this.contextStack.peek().getIdentifier() + "`");
            }
            this.contextStack.peek().close();
            if (this.contextStack.size() > 1) {
                this.heartBeatManager.sendHeartbeat();
            }
            this.contextStack.pop();
            System.gc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTask(EvaluatorRuntimeProtocol.StartTaskProto startTaskProto) throws TaskClientCodeException {
        Stack<ContextRuntime> stack = this.contextStack;
        synchronized (stack) {
            ContextRuntime currentActiveContext = this.contextStack.peek();
            String expectedContextId = startTaskProto.getContextId();
            if (!expectedContextId.equals(currentActiveContext.getIdentifier())) {
                throw new IllegalStateException("Task expected context `" + expectedContextId + "` but the active context has ID `" + currentActiveContext.getIdentifier() + "`");
            }
            try {
                Configuration taskConfig = this.configurationSerializer.fromString(startTaskProto.getConfiguration());
                currentActiveContext.startTask(taskConfig);
            }
            catch (IOException | BindException e) {
                throw new RuntimeException("Unable to read configuration.", e);
            }
        }
    }

    private void handleTaskException(TaskClientCodeException e) {
        LOG.log(Level.SEVERE, "TaskClientCodeException", e);
        ByteString exception = ByteString.copyFrom((byte[])this.exceptionCodec.toBytes(e.getCause()));
        ReefServiceProtos.TaskStatusProto taskStatus = ReefServiceProtos.TaskStatusProto.newBuilder().setContextId(e.getContextId()).setTaskId(e.getTaskId()).setResult(exception).setState(ReefServiceProtos.State.FAILED).build();
        LOG.log(Level.SEVERE, "Sending heartbeat: {0}", taskStatus);
        this.heartBeatManager.sendTaskStatus(taskStatus);
    }

    private void handleContextException(ContextClientCodeException e) {
        LOG.log(Level.SEVERE, "ContextClientCodeException", e);
        ByteString exception = ByteString.copyFrom((byte[])this.exceptionCodec.toBytes(e.getCause()));
        ReefServiceProtos.ContextStatusProto.Builder contextStatusBuilder = ReefServiceProtos.ContextStatusProto.newBuilder().setContextId(e.getContextID()).setContextState(ReefServiceProtos.ContextStatusProto.State.FAIL).setError(exception);
        if (e.getParentID().isPresent()) {
            contextStatusBuilder.setParentId((String)e.getParentID().get());
        }
        ReefServiceProtos.ContextStatusProto contextStatus = contextStatusBuilder.build();
        LOG.log(Level.SEVERE, "Sending heartbeat: {0}", contextStatus);
        this.heartBeatManager.sendContextStatus(contextStatus);
    }
}

