/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.evaluator.context;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.reef.evaluator.context.ContextMessageSource;
import org.apache.reef.evaluator.context.events.ContextStart;
import org.apache.reef.evaluator.context.events.ContextStop;
import org.apache.reef.evaluator.context.parameters.ContextIdentifier;
import org.apache.reef.evaluator.context.parameters.ContextMessageHandlers;
import org.apache.reef.evaluator.context.parameters.ContextMessageSources;
import org.apache.reef.evaluator.context.parameters.ContextStartHandlers;
import org.apache.reef.evaluator.context.parameters.ContextStopHandlers;
import org.apache.reef.runtime.common.evaluator.context.ContextStartImpl;
import org.apache.reef.runtime.common.evaluator.context.ContextStopImpl;
import org.apache.reef.runtime.common.utils.BroadCastEventHandler;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.wake.EventHandler;

final class ContextLifeCycle {
    private final String identifier;
    private final Set<EventHandler<ContextStart>> contextStartHandlers;
    private final Set<EventHandler<ContextStop>> contextStopHandlers;
    private final Set<ContextMessageSource> contextMessageSources;
    private final EventHandler<byte[]> contextMessageHandler;

    @Inject
    ContextLifeCycle(@Parameter(value=ContextIdentifier.class) String identifier, @Parameter(value=ContextMessageHandlers.class) Set<EventHandler<byte[]>> contextMessageHandlers, @Parameter(value=ContextStartHandlers.class) Set<EventHandler<ContextStart>> contextStartHandlers, @Parameter(value=ContextStopHandlers.class) Set<EventHandler<ContextStop>> contextStopHandlers, @Parameter(value=ContextMessageSources.class) Set<ContextMessageSource> contextMessageSources) {
        this.identifier = identifier;
        this.contextStartHandlers = contextStartHandlers;
        this.contextStopHandlers = contextStopHandlers;
        this.contextMessageSources = contextMessageSources;
        this.contextMessageHandler = new BroadCastEventHandler<byte[]>(contextMessageHandlers);
    }

    final void start() {
        ContextStartImpl contextStart = new ContextStartImpl(this.identifier);
        for (EventHandler<ContextStart> startHandler : this.contextStartHandlers) {
            startHandler.onNext((Object)contextStart);
        }
    }

    final void close() {
        ContextStopImpl contextStop = new ContextStopImpl(this.identifier);
        for (EventHandler<ContextStop> stopHandler : this.contextStopHandlers) {
            stopHandler.onNext((Object)contextStop);
        }
    }

    final void handleContextMessage(byte[] message) {
        this.contextMessageHandler.onNext((Object)message);
    }

    final Set<ContextMessageSource> getContextMessageSources() {
        return Collections.unmodifiableSet(new LinkedHashSet<ContextMessageSource>(this.contextMessageSources));
    }

    final String getIdentifier() {
        return this.identifier;
    }
}

