/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.evaluator.context;

import org.apache.reef.evaluator.context.parameters.ContextIdentifier;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.util.Optional;

public final class ContextClientCodeException
extends Exception {
    private final String contextID;
    private final Optional<String> parentID;

    public ContextClientCodeException(String contextID, Optional<String> parentID, String message, Throwable cause) {
        super("Failure in context '" + contextID + "': " + message, cause);
        this.contextID = contextID;
        this.parentID = parentID;
    }

    public static String getIdentifier(Configuration c) {
        try {
            return (String)Tang.Factory.getTang().newInjector(c).getNamedInstance(ContextIdentifier.class);
        }
        catch (InjectionException e) {
            throw new RuntimeException("Unable to determine context identifier. Giving up.", e);
        }
    }

    public String getContextID() {
        return this.contextID;
    }

    public Optional<String> getParentID() {
        return this.parentID;
    }
}

