/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.evaluator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.util.OSUtils;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.event.StartTime;

public class PIDStoreStartHandler
implements EventHandler<StartTime> {
    public static final String PID_FILE_NAME = "PID.txt";
    private static final Logger LOG = Logger.getLogger(PIDStoreStartHandler.class.getName());

    @Inject
    public PIDStoreStartHandler() {
    }

    public void onNext(StartTime startTime) {
        long pid = OSUtils.getPID();
        File outfile = new File(PID_FILE_NAME);
        LOG.log(Level.FINEST, "Storing pid `" + pid + "` in file " + outfile.getAbsolutePath());
        try (PrintWriter p = new PrintWriter(new FileOutputStream(PID_FILE_NAME));){
            p.write(String.valueOf(pid));
            p.write("\n");
        }
        catch (FileNotFoundException e) {
            LOG.log(Level.WARNING, "Unable to create PID file.", e);
        }
    }
}

