/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.evaluator;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.proto.EvaluatorRuntimeProtocol;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.evaluator.EvaluatorRuntime;
import org.apache.reef.runtime.common.evaluator.context.ContextManager;
import org.apache.reef.runtime.common.evaluator.parameters.DriverRemoteIdentifier;
import org.apache.reef.runtime.common.evaluator.parameters.HeartbeatPeriod;
import org.apache.reef.runtime.common.utils.RemoteManager;
import org.apache.reef.tang.InjectionFuture;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.util.Optional;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.Clock;
import org.apache.reef.wake.time.event.Alarm;

@Unit
public class HeartBeatManager {
    private static final Logger LOG = Logger.getLogger(HeartBeatManager.class.getName());
    private final Clock clock;
    private final int heartbeatPeriod;
    private final EventHandler<EvaluatorRuntimeProtocol.EvaluatorHeartbeatProto> evaluatorHeartbeatHandler;
    private final InjectionFuture<EvaluatorRuntime> evaluatorRuntime;
    private final InjectionFuture<ContextManager> contextManager;

    @Inject
    private HeartBeatManager(InjectionFuture<EvaluatorRuntime> evaluatorRuntime, InjectionFuture<ContextManager> contextManager, Clock clock, RemoteManager remoteManager, @Parameter(value=HeartbeatPeriod.class) int heartbeatPeriod, @Parameter(value=DriverRemoteIdentifier.class) String driverRID) {
        this.evaluatorRuntime = evaluatorRuntime;
        this.contextManager = contextManager;
        this.clock = clock;
        this.heartbeatPeriod = heartbeatPeriod;
        this.evaluatorHeartbeatHandler = remoteManager.getHandler(driverRID, EvaluatorRuntimeProtocol.EvaluatorHeartbeatProto.class);
    }

    public synchronized void sendHeartbeat() {
        this.sendHeartBeat(this.getEvaluatorHeartbeatProto());
    }

    public synchronized void sendTaskStatus(ReefServiceProtos.TaskStatusProto taskStatusProto) {
        this.sendHeartBeat(this.getEvaluatorHeartbeatProto(((EvaluatorRuntime)this.evaluatorRuntime.get()).getEvaluatorStatus(), ((ContextManager)this.contextManager.get()).getContextStatusCollection(), (Optional<ReefServiceProtos.TaskStatusProto>)Optional.of((Object)taskStatusProto)));
    }

    public synchronized void sendContextStatus(ReefServiceProtos.ContextStatusProto contextStatusProto) {
        ArrayList<ReefServiceProtos.ContextStatusProto> contextStatusList = new ArrayList<ReefServiceProtos.ContextStatusProto>();
        contextStatusList.add(contextStatusProto);
        contextStatusList.addAll(((ContextManager)this.contextManager.get()).getContextStatusCollection());
        EvaluatorRuntimeProtocol.EvaluatorHeartbeatProto heartbeatProto = this.getEvaluatorHeartbeatProto(((EvaluatorRuntime)this.evaluatorRuntime.get()).getEvaluatorStatus(), contextStatusList, (Optional<ReefServiceProtos.TaskStatusProto>)Optional.empty());
        this.sendHeartBeat(heartbeatProto);
    }

    public synchronized void sendEvaluatorStatus(ReefServiceProtos.EvaluatorStatusProto evaluatorStatusProto) {
        this.sendHeartBeat(EvaluatorRuntimeProtocol.EvaluatorHeartbeatProto.newBuilder().setTimestamp(System.currentTimeMillis()).setEvaluatorStatus(evaluatorStatusProto).build());
    }

    private synchronized void sendHeartBeat(EvaluatorRuntimeProtocol.EvaluatorHeartbeatProto heartbeatProto) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Heartbeat message:\n" + heartbeatProto, new Exception("Stack trace"));
        }
        this.evaluatorHeartbeatHandler.onNext((Object)heartbeatProto);
    }

    private EvaluatorRuntimeProtocol.EvaluatorHeartbeatProto getEvaluatorHeartbeatProto() {
        return this.getEvaluatorHeartbeatProto(((EvaluatorRuntime)this.evaluatorRuntime.get()).getEvaluatorStatus(), ((ContextManager)this.contextManager.get()).getContextStatusCollection(), ((ContextManager)this.contextManager.get()).getTaskStatus());
    }

    private final EvaluatorRuntimeProtocol.EvaluatorHeartbeatProto getEvaluatorHeartbeatProto(ReefServiceProtos.EvaluatorStatusProto evaluatorStatusProto, Iterable<ReefServiceProtos.ContextStatusProto> contextStatusProtos, Optional<ReefServiceProtos.TaskStatusProto> taskStatusProto) {
        EvaluatorRuntimeProtocol.EvaluatorHeartbeatProto.Builder builder = EvaluatorRuntimeProtocol.EvaluatorHeartbeatProto.newBuilder().setTimestamp(System.currentTimeMillis()).setEvaluatorStatus(evaluatorStatusProto);
        for (ReefServiceProtos.ContextStatusProto contextStatusProto : contextStatusProtos) {
            builder.addContextStatus(contextStatusProto);
        }
        if (taskStatusProto.isPresent()) {
            builder.setTaskStatus((ReefServiceProtos.TaskStatusProto)taskStatusProto.get());
        }
        return builder.build();
    }

    final class HeartbeatAlarmHandler
    implements EventHandler<Alarm> {
        HeartbeatAlarmHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(Alarm alarm) {
            HeartBeatManager heartBeatManager = HeartBeatManager.this;
            synchronized (heartBeatManager) {
                if (((EvaluatorRuntime)HeartBeatManager.this.evaluatorRuntime.get()).isRunning()) {
                    HeartBeatManager.this.sendHeartbeat();
                    HeartBeatManager.this.clock.scheduleAlarm(HeartBeatManager.this.heartbeatPeriod, (EventHandler)this);
                } else {
                    LOG.log(Level.FINEST, "Not triggering a heartbeat, because state is: {0}", (Object)((EvaluatorRuntime)HeartBeatManager.this.evaluatorRuntime.get()).getState());
                }
            }
        }
    }
}

