/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.evaluator;

import com.google.protobuf.ByteString;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.EvaluatorSide;
import org.apache.reef.proto.EvaluatorRuntimeProtocol;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.evaluator.HeartBeatManager;
import org.apache.reef.runtime.common.evaluator.context.ContextManager;
import org.apache.reef.runtime.common.evaluator.parameters.DriverRemoteIdentifier;
import org.apache.reef.runtime.common.evaluator.parameters.EvaluatorIdentifier;
import org.apache.reef.runtime.common.evaluator.parameters.HeartbeatPeriod;
import org.apache.reef.runtime.common.utils.ExceptionCodec;
import org.apache.reef.runtime.common.utils.RemoteManager;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.Clock;
import org.apache.reef.wake.time.runtime.event.RuntimeStart;
import org.apache.reef.wake.time.runtime.event.RuntimeStop;

@Unit
@EvaluatorSide
final class EvaluatorRuntime
implements EventHandler<EvaluatorRuntimeProtocol.EvaluatorControlProto> {
    private static final Logger LOG = Logger.getLogger(EvaluatorRuntime.class.getName());
    private final HeartBeatManager heartBeatManager;
    private final ContextManager contextManager;
    private final Clock clock;
    private final String evaluatorIdentifier;
    private final ExceptionCodec exceptionCodec;
    private final AutoCloseable evaluatorControlChannel;
    private ReefServiceProtos.State state = ReefServiceProtos.State.INIT;

    @Inject
    private EvaluatorRuntime(@Parameter(value=HeartbeatPeriod.class) int heartbeatPeriod, @Parameter(value=EvaluatorIdentifier.class) String evaluatorIdentifier, @Parameter(value=DriverRemoteIdentifier.class) String driverRID, HeartBeatManager.HeartbeatAlarmHandler heartbeatAlarmHandler, HeartBeatManager heartBeatManager, Clock clock, ContextManager contextManagerFuture, RemoteManager remoteManager, ExceptionCodec exceptionCodec) {
        this.heartBeatManager = heartBeatManager;
        this.contextManager = contextManagerFuture;
        this.clock = clock;
        this.evaluatorIdentifier = evaluatorIdentifier;
        this.exceptionCodec = exceptionCodec;
        this.evaluatorControlChannel = remoteManager.registerHandler(driverRID, EvaluatorRuntimeProtocol.EvaluatorControlProto.class, this);
        clock.scheduleAlarm(heartbeatPeriod, (EventHandler)heartbeatAlarmHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEvaluatorControlMessage(EvaluatorRuntimeProtocol.EvaluatorControlProto message) {
        HeartBeatManager heartBeatManager = this.heartBeatManager;
        synchronized (heartBeatManager) {
            LOG.log(Level.FINEST, "Evaluator control message");
            if (!message.getIdentifier().equals(this.evaluatorIdentifier)) {
                this.onException(new RuntimeException("Identifier mismatch: message for evaluator id[" + message.getIdentifier() + "] sent to evaluator id[" + this.evaluatorIdentifier + "]"));
            } else if (ReefServiceProtos.State.RUNNING != this.state) {
                this.onException(new RuntimeException("Evaluator sent a control message but its state is not " + (Object)((Object)ReefServiceProtos.State.RUNNING) + " but rather " + (Object)((Object)this.state)));
            } else {
                if (message.hasContextControl()) {
                    LOG.log(Level.FINEST, "Send task control message to ContextManager");
                    try {
                        this.contextManager.handleContextControlProtocol(message.getContextControl());
                        if (this.contextManager.contextStackIsEmpty() && this.state == ReefServiceProtos.State.RUNNING) {
                            this.state = ReefServiceProtos.State.DONE;
                            this.heartBeatManager.sendEvaluatorStatus(this.getEvaluatorStatus());
                            this.clock.close();
                        }
                    }
                    catch (Throwable e) {
                        this.onException(e);
                        throw new RuntimeException(e);
                    }
                }
                if (message.hasKillEvaluator()) {
                    LOG.log(Level.SEVERE, "Evaluator {0} has been killed by the driver.", this.evaluatorIdentifier);
                    this.state = ReefServiceProtos.State.KILLED;
                    this.clock.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onException(Throwable exception) {
        HeartBeatManager heartBeatManager = this.heartBeatManager;
        synchronized (heartBeatManager) {
            this.state = ReefServiceProtos.State.FAILED;
            ReefServiceProtos.EvaluatorStatusProto evaluatorStatusProto = ReefServiceProtos.EvaluatorStatusProto.newBuilder().setEvaluatorId(this.evaluatorIdentifier).setError(ByteString.copyFrom((byte[])this.exceptionCodec.toBytes(exception))).setState(this.state).build();
            this.heartBeatManager.sendEvaluatorStatus(evaluatorStatusProto);
            this.contextManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReefServiceProtos.EvaluatorStatusProto getEvaluatorStatus() {
        HeartBeatManager heartBeatManager = this.heartBeatManager;
        synchronized (heartBeatManager) {
            LOG.log(Level.FINEST, "Evaluator heartbeat: state = {0}", (Object)this.state);
            ReefServiceProtos.EvaluatorStatusProto.Builder evaluatorStatus = ReefServiceProtos.EvaluatorStatusProto.newBuilder().setEvaluatorId(this.evaluatorIdentifier).setState(this.state);
            return evaluatorStatus.build();
        }
    }

    final ReefServiceProtos.State getState() {
        return this.state;
    }

    boolean isRunning() {
        return this.state == ReefServiceProtos.State.RUNNING;
    }

    public void onNext(EvaluatorRuntimeProtocol.EvaluatorControlProto evaluatorControlProto) {
        this.onEvaluatorControlMessage(evaluatorControlProto);
    }

    final class RuntimeStopHandler
    implements EventHandler<RuntimeStop> {
        RuntimeStopHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onNext(RuntimeStop runtimeStop) {
            HeartBeatManager heartBeatManager = EvaluatorRuntime.this.heartBeatManager;
            synchronized (heartBeatManager) {
                LOG.log(Level.FINEST, "EvaluatorRuntime shutdown invoked for Evaluator {0} in state {1}", new Object[]{EvaluatorRuntime.this.evaluatorIdentifier, EvaluatorRuntime.this.state});
                if (EvaluatorRuntime.this.isRunning()) {
                    EvaluatorRuntime.this.onException(new RuntimeException("RuntimeStopHandler invoked in state RUNNING.", runtimeStop.getException()));
                } else {
                    EvaluatorRuntime.this.contextManager.close();
                    try {
                        EvaluatorRuntime.this.evaluatorControlChannel.close();
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Exception during shutdown of evaluatorControlChannel.", e);
                    }
                    LOG.log(Level.FINEST, "EvaluatorRuntime shutdown complete");
                }
            }
        }
    }

    final class RuntimeStartHandler
    implements EventHandler<RuntimeStart> {
        RuntimeStartHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onNext(RuntimeStart runtimeStart) {
            HeartBeatManager heartBeatManager = EvaluatorRuntime.this.heartBeatManager;
            synchronized (heartBeatManager) {
                try {
                    LOG.log(Level.FINEST, "runtime start");
                    assert (ReefServiceProtos.State.INIT == EvaluatorRuntime.this.state);
                    EvaluatorRuntime.this.state = ReefServiceProtos.State.RUNNING;
                    EvaluatorRuntime.this.contextManager.start();
                    EvaluatorRuntime.this.heartBeatManager.sendHeartbeat();
                }
                catch (Throwable e) {
                    EvaluatorRuntime.this.onException(e);
                }
            }
        }
    }
}

