/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.task;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.driver.context.ActiveContext;
import org.apache.reef.driver.task.FailedTask;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.driver.context.EvaluatorContext;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorManager;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorMessageDispatcher;
import org.apache.reef.runtime.common.driver.task.CompletedTaskImpl;
import org.apache.reef.runtime.common.driver.task.RunningTaskImpl;
import org.apache.reef.runtime.common.driver.task.SuspendedTaskImpl;
import org.apache.reef.runtime.common.driver.task.TaskMessageImpl;
import org.apache.reef.runtime.common.utils.ExceptionCodec;
import org.apache.reef.util.Optional;

@DriverSide
@Private
public final class TaskRepresenter {
    private static final Logger LOG = Logger.getLogger(TaskRepresenter.class.getName());
    private final EvaluatorContext context;
    private final EvaluatorMessageDispatcher messageDispatcher;
    private final EvaluatorManager evaluatorManager;
    private final ExceptionCodec exceptionCodec;
    private final String taskId;
    private ReefServiceProtos.State state = ReefServiceProtos.State.INIT;

    public TaskRepresenter(String taskId, EvaluatorContext context, EvaluatorMessageDispatcher messageDispatcher, EvaluatorManager evaluatorManager, ExceptionCodec exceptionCodec) {
        this.taskId = taskId;
        this.context = context;
        this.messageDispatcher = messageDispatcher;
        this.evaluatorManager = evaluatorManager;
        this.exceptionCodec = exceptionCodec;
    }

    private static byte[] getResult(ReefServiceProtos.TaskStatusProto taskStatusProto) {
        return taskStatusProto.hasResult() ? taskStatusProto.getResult().toByteArray() : null;
    }

    public void onTaskStatusMessage(ReefServiceProtos.TaskStatusProto taskStatusProto) {
        LOG.log(Level.FINE, "Received task {0} status {1}", new Object[]{taskStatusProto.getTaskId(), taskStatusProto.getState()});
        if (!taskStatusProto.getContextId().equals(this.context.getId())) {
            throw new RuntimeException("Received a message for a task running on Context " + taskStatusProto.getContextId() + " while the Driver believes this Task to be run on Context " + this.context.getId());
        }
        if (!taskStatusProto.getTaskId().equals(this.taskId)) {
            throw new RuntimeException("Received a message for task " + taskStatusProto.getTaskId() + " in the TaskRepresenter for Task " + this.taskId);
        }
        if (taskStatusProto.getRecovery()) {
            LOG.log(Level.INFO, "Received task status {0} for RECOVERED task {1}.", new Object[]{taskStatusProto.getState(), this.taskId});
            this.setState(taskStatusProto.getState());
        }
        switch (taskStatusProto.getState()) {
            case INIT: {
                this.onTaskInit(taskStatusProto);
                break;
            }
            case RUNNING: {
                this.onTaskRunning(taskStatusProto);
                break;
            }
            case SUSPEND: {
                this.onTaskSuspend(taskStatusProto);
                break;
            }
            case DONE: {
                this.onTaskDone(taskStatusProto);
                break;
            }
            case FAILED: {
                this.onTaskFailed(taskStatusProto);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown task state: " + (Object)((Object)taskStatusProto.getState()));
            }
        }
    }

    private void onTaskInit(ReefServiceProtos.TaskStatusProto taskStatusProto) {
        assert (ReefServiceProtos.State.INIT == taskStatusProto.getState());
        if (this.isKnown()) {
            LOG.log(Level.WARNING, "Received a INIT message for task with id {0} which we have seen before. Ignoring the second message", this.taskId);
        } else {
            RunningTaskImpl runningTask = new RunningTaskImpl(this.evaluatorManager, this.taskId, this.context, this);
            this.messageDispatcher.onTaskRunning(runningTask);
            this.setState(ReefServiceProtos.State.RUNNING);
        }
    }

    private void onTaskRunning(ReefServiceProtos.TaskStatusProto taskStatusProto) {
        assert (taskStatusProto.getState() == ReefServiceProtos.State.RUNNING);
        if (this.isNotRunning()) {
            throw new IllegalStateException("Received a task status message from task " + this.taskId + " that is believed to be RUNNING on the Evaluator, but the Driver thinks it is in state " + (Object)((Object)this.state));
        }
        if (taskStatusProto.getRecovery()) {
            RunningTaskImpl runningTask = new RunningTaskImpl(this.evaluatorManager, this.taskId, this.context, this);
            this.messageDispatcher.onDriverRestartTaskRunning(runningTask);
        }
        for (ReefServiceProtos.TaskStatusProto.TaskMessageProto taskMessageProto : taskStatusProto.getTaskMessageList()) {
            this.messageDispatcher.onTaskMessage(new TaskMessageImpl(taskMessageProto.getMessage().toByteArray(), this.taskId, this.context.getId(), taskMessageProto.getSourceId()));
        }
    }

    private void onTaskSuspend(ReefServiceProtos.TaskStatusProto taskStatusProto) {
        assert (ReefServiceProtos.State.SUSPEND == taskStatusProto.getState());
        assert (this.isKnown());
        this.messageDispatcher.onTaskSuspended(new SuspendedTaskImpl(this.context, TaskRepresenter.getResult(taskStatusProto), this.taskId));
        this.setState(ReefServiceProtos.State.SUSPEND);
    }

    private void onTaskDone(ReefServiceProtos.TaskStatusProto taskStatusProto) {
        assert (ReefServiceProtos.State.DONE == taskStatusProto.getState());
        assert (this.isKnown());
        this.messageDispatcher.onTaskCompleted(new CompletedTaskImpl(this.context, TaskRepresenter.getResult(taskStatusProto), this.taskId));
        this.setState(ReefServiceProtos.State.DONE);
    }

    private void onTaskFailed(ReefServiceProtos.TaskStatusProto taskStatusProto) {
        assert (ReefServiceProtos.State.FAILED == taskStatusProto.getState());
        Optional evaluatorContext = Optional.of((Object)this.context);
        Optional bytes = Optional.ofNullable((Object)TaskRepresenter.getResult(taskStatusProto));
        Optional<Throwable> exception = this.exceptionCodec.fromBytes((Optional<byte[]>)bytes);
        String message = exception.isPresent() ? ((Throwable)exception.get()).getMessage() : "No message given";
        Optional description = Optional.empty();
        FailedTask failedTask = new FailedTask(this.taskId, message, (Optional<String>)description, exception, (Optional<byte[]>)bytes, (Optional<ActiveContext>)evaluatorContext);
        this.messageDispatcher.onTaskFailed(failedTask);
        this.setState(ReefServiceProtos.State.FAILED);
    }

    public String getId() {
        return this.taskId;
    }

    private boolean isKnown() {
        return this.state != ReefServiceProtos.State.INIT;
    }

    public boolean isNotRunning() {
        return this.state != ReefServiceProtos.State.RUNNING;
    }

    private void setState(ReefServiceProtos.State newState) {
        LOG.log(Level.FINE, "Task [{0}] state transition from [{1}] to [{2}]", new Object[]{this.taskId, this.state, newState});
        this.state = newState;
    }
}

