/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.task;

import com.google.protobuf.ByteString;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.driver.context.ActiveContext;
import org.apache.reef.driver.task.RunningTask;
import org.apache.reef.proto.EvaluatorRuntimeProtocol;
import org.apache.reef.runtime.common.driver.context.EvaluatorContext;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorManager;
import org.apache.reef.runtime.common.driver.task.TaskRepresenter;

@Private
@DriverSide
public final class RunningTaskImpl
implements RunningTask {
    private static final Logger LOG = Logger.getLogger(RunningTask.class.getName());
    private final EvaluatorManager evaluatorManager;
    private final EvaluatorContext evaluatorContext;
    private final String taskId;
    private final TaskRepresenter taskRepresenter;

    public RunningTaskImpl(EvaluatorManager evaluatorManager, String taskId, EvaluatorContext evaluatorContext, TaskRepresenter taskRepresenter) {
        LOG.log(Level.FINEST, "INIT: TaskRuntime id[" + taskId + "] on evaluator id[" + evaluatorManager.getId() + "]");
        this.evaluatorManager = evaluatorManager;
        this.evaluatorContext = evaluatorContext;
        this.taskId = taskId;
        this.taskRepresenter = taskRepresenter;
    }

    @Override
    public ActiveContext getActiveContext() {
        return this.evaluatorContext;
    }

    @Override
    public String getId() {
        return this.taskId;
    }

    @Override
    public void send(byte[] message) {
        LOG.log(Level.FINEST, "MESSAGE: Task id[" + this.taskId + "] on evaluator id[" + this.evaluatorManager.getId() + "]");
        EvaluatorRuntimeProtocol.ContextControlProto contextControlProto = EvaluatorRuntimeProtocol.ContextControlProto.newBuilder().setTaskMessage(ByteString.copyFrom((byte[])message)).build();
        this.evaluatorManager.sendContextControlMessage(contextControlProto);
    }

    @Override
    public void close() {
        LOG.log(Level.FINEST, "CLOSE: TaskRuntime id[" + this.taskId + "] on evaluator id[" + this.evaluatorManager.getId() + "]");
        if (this.taskRepresenter.isNotRunning()) {
            LOG.log(Level.FINE, "Ignoring call to .close() because the task is no longer RUNNING.");
        } else {
            EvaluatorRuntimeProtocol.ContextControlProto contextControlProto = EvaluatorRuntimeProtocol.ContextControlProto.newBuilder().setStopTask(EvaluatorRuntimeProtocol.StopTaskProto.newBuilder().build()).build();
            this.evaluatorManager.sendContextControlMessage(contextControlProto);
        }
    }

    @Override
    public void close(byte[] message) {
        LOG.log(Level.FINEST, "CLOSE: TaskRuntime id[" + this.taskId + "] on evaluator id[" + this.evaluatorManager.getId() + "] with message.");
        if (this.taskRepresenter.isNotRunning()) {
            throw new RuntimeException("Trying to send a message to a Task that is no longer RUNNING.");
        }
        EvaluatorRuntimeProtocol.ContextControlProto contextControlProto = EvaluatorRuntimeProtocol.ContextControlProto.newBuilder().setStopTask(EvaluatorRuntimeProtocol.StopTaskProto.newBuilder().build()).setTaskMessage(ByteString.copyFrom((byte[])message)).build();
        this.evaluatorManager.sendContextControlMessage(contextControlProto);
    }

    @Override
    public void suspend(byte[] message) {
        LOG.log(Level.FINEST, "SUSPEND: TaskRuntime id[" + this.taskId + "] on evaluator id[" + this.evaluatorManager.getId() + "] with message.");
        EvaluatorRuntimeProtocol.ContextControlProto contextControlProto = EvaluatorRuntimeProtocol.ContextControlProto.newBuilder().setSuspendTask(EvaluatorRuntimeProtocol.SuspendTaskProto.newBuilder().build()).setTaskMessage(ByteString.copyFrom((byte[])message)).build();
        this.evaluatorManager.sendContextControlMessage(contextControlProto);
    }

    @Override
    public void suspend() {
        LOG.log(Level.FINEST, "SUSPEND: TaskRuntime id[" + this.taskId + "] on evaluator id[" + this.evaluatorManager.getId() + "]");
        EvaluatorRuntimeProtocol.ContextControlProto contextControlProto = EvaluatorRuntimeProtocol.ContextControlProto.newBuilder().setSuspendTask(EvaluatorRuntimeProtocol.SuspendTaskProto.newBuilder().build()).build();
        this.evaluatorManager.sendContextControlMessage(contextControlProto);
    }

    public String toString() {
        return "RunningTask{taskId='" + this.taskId + "'}";
    }
}

