/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.resourcemanager;

import java.util.ArrayList;
import java.util.List;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.driver.resourcemanager.RuntimeStatusEvent;
import org.apache.reef.util.BuilderUtils;
import org.apache.reef.util.Optional;

public final class RuntimeStatusEventImpl
implements RuntimeStatusEvent {
    private final String name;
    private final ReefServiceProtos.State state;
    private final List<String> containerAllocationList;
    private final Optional<ReefServiceProtos.RuntimeErrorProto> error;
    private final Optional<Integer> outstandingContainerRequests;

    private RuntimeStatusEventImpl(Builder builder) {
        this.name = BuilderUtils.notNull(builder.name);
        this.state = BuilderUtils.notNull(builder.state);
        this.containerAllocationList = BuilderUtils.notNull(builder.containerAllocationList);
        this.error = Optional.ofNullable((Object)builder.error);
        this.outstandingContainerRequests = Optional.ofNullable((Object)builder.outstandingContainerRequests);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ReefServiceProtos.State getState() {
        return this.state;
    }

    @Override
    public List<String> getContainerAllocationList() {
        return this.containerAllocationList;
    }

    @Override
    public Optional<ReefServiceProtos.RuntimeErrorProto> getError() {
        return this.error;
    }

    @Override
    public Optional<Integer> getOutstandingContainerRequests() {
        return this.outstandingContainerRequests;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements org.apache.reef.util.Builder<RuntimeStatusEvent> {
        private String name;
        private ReefServiceProtos.State state;
        private List<String> containerAllocationList = new ArrayList<String>();
        private ReefServiceProtos.RuntimeErrorProto error;
        private Integer outstandingContainerRequests;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setState(ReefServiceProtos.State state) {
            this.state = state;
            return this;
        }

        public Builder addContainerAllocation(String containerAllocation) {
            this.containerAllocationList.add(containerAllocation);
            return this;
        }

        public Builder setError(ReefServiceProtos.RuntimeErrorProto error) {
            this.error = error;
            return this;
        }

        public Builder setOutstandingContainerRequests(int outstandingContainerRequests) {
            this.outstandingContainerRequests = outstandingContainerRequests;
            return this;
        }

        @Override
        public RuntimeStatusEvent build() {
            return new RuntimeStatusEventImpl(this);
        }
    }
}

