/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.resourcemanager;

import javax.inject.Inject;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorManager;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorManagerFactory;
import org.apache.reef.runtime.common.driver.evaluator.Evaluators;
import org.apache.reef.runtime.common.driver.resourcemanager.ResourceStatusEvent;
import org.apache.reef.util.Optional;
import org.apache.reef.wake.EventHandler;

@Private
public final class ResourceStatusHandler
implements EventHandler<ResourceStatusEvent> {
    private final Evaluators evaluators;
    private final EvaluatorManagerFactory evaluatorManagerFactory;

    @Inject
    ResourceStatusHandler(Evaluators evaluators, EvaluatorManagerFactory evaluatorManagerFactory) {
        this.evaluators = evaluators;
        this.evaluatorManagerFactory = evaluatorManagerFactory;
    }

    public void onNext(ResourceStatusEvent resourceStatusEvent) {
        Optional<EvaluatorManager> evaluatorManager = this.evaluators.get(resourceStatusEvent.getIdentifier());
        if (evaluatorManager.isPresent()) {
            ((EvaluatorManager)evaluatorManager.get()).onResourceStatusMessage(resourceStatusEvent);
        } else if (((Boolean)resourceStatusEvent.getIsFromPreviousDriver().get()).booleanValue()) {
            EvaluatorManager previousEvaluatorManager = this.evaluatorManagerFactory.createForEvaluatorFailedDuringDriverRestart(resourceStatusEvent);
            previousEvaluatorManager.onResourceStatusMessage(resourceStatusEvent);
        } else {
            throw new RuntimeException("Unknown resource status from evaluator " + resourceStatusEvent.getIdentifier() + " with state " + (Object)((Object)resourceStatusEvent.getState()));
        }
    }
}

