/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.resourcemanager;

import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.driver.resourcemanager.ResourceStatusEvent;
import org.apache.reef.util.BuilderUtils;
import org.apache.reef.util.Optional;

public final class ResourceStatusEventImpl
implements ResourceStatusEvent {
    private final String identifier;
    private final ReefServiceProtos.State state;
    private final Optional<String> diagnostics;
    private final Optional<Integer> exitCode;
    private final Optional<Boolean> isFromPreviousDriver;

    private ResourceStatusEventImpl(Builder builder) {
        this.identifier = BuilderUtils.notNull(builder.identifier);
        this.state = BuilderUtils.notNull(builder.state);
        this.diagnostics = Optional.ofNullable((Object)builder.diagnostics);
        this.exitCode = Optional.ofNullable((Object)builder.exitCode);
        this.isFromPreviousDriver = Optional.ofNullable((Object)builder.isFromPreviousDriver);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public ReefServiceProtos.State getState() {
        return this.state;
    }

    @Override
    public Optional<String> getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    public Optional<Integer> getExitCode() {
        return this.exitCode;
    }

    @Override
    public Optional<Boolean> getIsFromPreviousDriver() {
        return this.isFromPreviousDriver;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements org.apache.reef.util.Builder<ResourceStatusEvent> {
        private String identifier;
        private ReefServiceProtos.State state;
        private String diagnostics;
        private Integer exitCode;
        private Boolean isFromPreviousDriver;

        public Builder setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder setState(ReefServiceProtos.State state) {
            this.state = state;
            return this;
        }

        public Builder setDiagnostics(String diagnostics) {
            this.diagnostics = diagnostics;
            return this;
        }

        public Builder setExitCode(int exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public Builder setIsFromPreviousDriver(boolean isFromPreviousDriver) {
            this.isFromPreviousDriver = isFromPreviousDriver;
            return this;
        }

        @Override
        public ResourceStatusEvent build() {
            return new ResourceStatusEventImpl(this);
        }
    }
}

