/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.resourcemanager;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.driver.DriverStatusManager;
import org.apache.reef.runtime.common.driver.idle.DriverIdleManager;
import org.apache.reef.runtime.common.driver.idle.DriverIdlenessSource;
import org.apache.reef.runtime.common.driver.idle.IdleMessage;
import org.apache.reef.runtime.common.driver.resourcemanager.ResourceManagerErrorHandler;
import org.apache.reef.runtime.common.driver.resourcemanager.RuntimeStatusEvent;
import org.apache.reef.tang.InjectionFuture;
import org.apache.reef.wake.EventHandler;

@DriverSide
@Private
public final class ResourceManagerStatus
implements EventHandler<RuntimeStatusEvent>,
DriverIdlenessSource {
    private static final Logger LOG = Logger.getLogger(ResourceManagerStatus.class.getName());
    private static final String COMPONENT_NAME = "ResourceManager";
    private static final IdleMessage IDLE_MESSAGE = new IdleMessage("ResourceManager", "No outstanding requests or allocations", true);
    private final ResourceManagerErrorHandler resourceManagerErrorHandler;
    private final DriverStatusManager driverStatusManager;
    private final InjectionFuture<DriverIdleManager> driverIdleManager;
    private ReefServiceProtos.State state = ReefServiceProtos.State.INIT;
    private int outstandingContainerRequests = 0;
    private int containerAllocationCount = 0;

    @Inject
    ResourceManagerStatus(ResourceManagerErrorHandler resourceManagerErrorHandler, DriverStatusManager driverStatusManager, InjectionFuture<DriverIdleManager> driverIdleManager) {
        this.resourceManagerErrorHandler = resourceManagerErrorHandler;
        this.driverStatusManager = driverStatusManager;
        this.driverIdleManager = driverIdleManager;
    }

    public synchronized void onNext(RuntimeStatusEvent runtimeStatusEvent) {
        ReefServiceProtos.State newState = runtimeStatusEvent.getState();
        LOG.log(Level.FINEST, "Runtime status " + runtimeStatusEvent);
        this.outstandingContainerRequests = (Integer)runtimeStatusEvent.getOutstandingContainerRequests().get();
        this.containerAllocationCount = runtimeStatusEvent.getContainerAllocationList().size();
        this.setState(runtimeStatusEvent.getState());
        switch (newState) {
            case FAILED: {
                this.onRMFailure(runtimeStatusEvent);
                break;
            }
            case DONE: {
                this.onRMDone(runtimeStatusEvent);
                break;
            }
            case RUNNING: {
                this.onRMRunning(runtimeStatusEvent);
            }
        }
    }

    public synchronized void setRunning() {
        this.setState(ReefServiceProtos.State.RUNNING);
    }

    @Override
    public synchronized IdleMessage getIdleStatus() {
        if (this.isIdle()) {
            return IDLE_MESSAGE;
        }
        String message = "There are " + this.outstandingContainerRequests + " outstanding container requests and " + this.containerAllocationCount + " allocated containers";
        return new IdleMessage(COMPONENT_NAME, message, false);
    }

    private synchronized void onRMFailure(RuntimeStatusEvent runtimeStatusEvent) {
        assert (runtimeStatusEvent.getState() == ReefServiceProtos.State.FAILED);
        this.resourceManagerErrorHandler.onNext((ReefServiceProtos.RuntimeErrorProto)runtimeStatusEvent.getError().get());
    }

    private synchronized void onRMDone(RuntimeStatusEvent runtimeStatusEvent) {
        assert (runtimeStatusEvent.getState() == ReefServiceProtos.State.DONE);
        LOG.log(Level.INFO, "Resource Manager shutdown happened. Triggering Driver shutdown.");
        this.driverStatusManager.onComplete();
    }

    private synchronized void onRMRunning(RuntimeStatusEvent runtimeStatusEvent) {
        assert (runtimeStatusEvent.getState() == ReefServiceProtos.State.RUNNING);
        if (this.isIdle()) {
            ((DriverIdleManager)this.driverIdleManager.get()).onPotentiallyIdle(IDLE_MESSAGE);
        }
    }

    private synchronized boolean isIdle() {
        return this.hasNoOutstandingRequests() && this.hasNoContainersAllocated();
    }

    private synchronized boolean isRunning() {
        return ReefServiceProtos.State.RUNNING.equals((Object)this.state);
    }

    private synchronized void setState(ReefServiceProtos.State state) {
        this.state = state;
    }

    private synchronized boolean hasNoOutstandingRequests() {
        return this.outstandingContainerRequests == 0;
    }

    private synchronized boolean hasNoContainersAllocated() {
        return this.containerAllocationCount == 0;
    }
}

