/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.resourcemanager;

import org.apache.reef.runtime.common.driver.resourcemanager.ResourceAllocationEvent;
import org.apache.reef.util.BuilderUtils;
import org.apache.reef.util.Optional;

public final class ResourceAllocationEventImpl
implements ResourceAllocationEvent {
    private final String identifier;
    private final int resourceMemory;
    private final String nodeId;
    private final Optional<Integer> virtualCores;

    private ResourceAllocationEventImpl(Builder builder) {
        this.identifier = BuilderUtils.notNull(builder.identifier);
        this.resourceMemory = BuilderUtils.notNull(builder.resourceMemory);
        this.nodeId = BuilderUtils.notNull(builder.nodeId);
        this.virtualCores = Optional.ofNullable((Object)builder.virtualCores);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getResourceMemory() {
        return this.resourceMemory;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public Optional<Integer> getVirtualCores() {
        return this.virtualCores;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements org.apache.reef.util.Builder<ResourceAllocationEvent> {
        private String identifier;
        private Integer resourceMemory;
        private String nodeId;
        private Integer virtualCores;

        public Builder setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder setResourceMemory(int resourceMemory) {
            this.resourceMemory = resourceMemory;
            return this;
        }

        public Builder setNodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setVirtualCores(int virtualCores) {
            this.virtualCores = virtualCores;
            return this;
        }

        @Override
        public ResourceAllocationEvent build() {
            return new ResourceAllocationEventImpl(this);
        }
    }
}

