/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.resourcemanager;

import org.apache.reef.runtime.common.driver.resourcemanager.NodeDescriptorEvent;
import org.apache.reef.util.BuilderUtils;
import org.apache.reef.util.Optional;

public final class NodeDescriptorEventImpl
implements NodeDescriptorEvent {
    private final String identifier;
    private final String hostName;
    private final int port;
    private final int memorySize;
    private final Optional<String> rackName;

    private NodeDescriptorEventImpl(Builder builder) {
        this.identifier = BuilderUtils.notNull(builder.identifier);
        this.hostName = BuilderUtils.notNull(builder.hostName);
        this.port = BuilderUtils.notNull(builder.port);
        this.memorySize = BuilderUtils.notNull(builder.memorySize);
        this.rackName = Optional.ofNullable((Object)builder.rackName);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int getMemorySize() {
        return this.memorySize;
    }

    @Override
    public Optional<String> getRackName() {
        return this.rackName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements org.apache.reef.util.Builder<NodeDescriptorEvent> {
        private String identifier;
        private String hostName;
        private Integer port;
        private Integer memorySize;
        private String rackName;

        public Builder setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder setHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setMemorySize(int memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public Builder setRackName(String rackName) {
            this.rackName = rackName;
            return this;
        }

        @Override
        public NodeDescriptorEvent build() {
            return new NodeDescriptorEventImpl(this);
        }
    }
}

