/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.idle;

import javax.inject.Inject;
import org.apache.reef.runtime.common.driver.evaluator.Evaluators;
import org.apache.reef.runtime.common.driver.idle.DriverIdleManager;
import org.apache.reef.runtime.common.driver.idle.DriverIdlenessSource;
import org.apache.reef.runtime.common.driver.idle.IdleMessage;
import org.apache.reef.tang.InjectionFuture;

public final class EventHandlerIdlenessSource
implements DriverIdlenessSource {
    private static final IdleMessage IDLE_MESSAGE = new IdleMessage("EventHandlers", "All events have been processed.", true);
    private static final IdleMessage NOT_IDLE_MESSAGE = new IdleMessage("EventHandlers", "Some events are still in flight.", true);
    private final InjectionFuture<Evaluators> evaluators;
    private final InjectionFuture<DriverIdleManager> driverIdleManager;

    @Inject
    EventHandlerIdlenessSource(InjectionFuture<Evaluators> evaluators, InjectionFuture<DriverIdleManager> driverIdleManager) {
        this.evaluators = evaluators;
        this.driverIdleManager = driverIdleManager;
    }

    @Override
    public IdleMessage getIdleStatus() {
        if (((Evaluators)this.evaluators.get()).allEvaluatorsAreClosed()) {
            return IDLE_MESSAGE;
        }
        return NOT_IDLE_MESSAGE;
    }

    public void check() {
        if (((Evaluators)this.evaluators.get()).allEvaluatorsAreClosed()) {
            ((DriverIdleManager)this.driverIdleManager.get()).onPotentiallyIdle(IDLE_MESSAGE);
        }
    }
}

