/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.idle;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.parameters.DriverIdleSources;
import org.apache.reef.runtime.common.driver.DriverStatusManager;
import org.apache.reef.runtime.common.driver.idle.DriverIdlenessSource;
import org.apache.reef.runtime.common.driver.idle.IdleMessage;
import org.apache.reef.tang.InjectionFuture;
import org.apache.reef.tang.annotations.Parameter;

public final class DriverIdleManager {
    private static final Logger LOG = Logger.getLogger(DriverIdleManager.class.getName());
    private static final Level IDLE_REASONS_LEVEL = Level.FINEST;
    private final Set<DriverIdlenessSource> idlenessSources;
    private final InjectionFuture<DriverStatusManager> driverStatusManager;

    @Inject
    DriverIdleManager(@Parameter(value=DriverIdleSources.class) Set<DriverIdlenessSource> idlenessSources, InjectionFuture<DriverStatusManager> driverStatusManager) {
        this.idlenessSources = idlenessSources;
        this.driverStatusManager = driverStatusManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onPotentiallyIdle(IdleMessage reason) {
        DriverStatusManager driverStatusManager = (DriverStatusManager)this.driverStatusManager.get();
        synchronized (driverStatusManager) {
            if (((DriverStatusManager)this.driverStatusManager.get()).isShuttingDownOrFailing()) {
                LOG.log(IDLE_REASONS_LEVEL, "Ignoring idle call from [{0}] for reason [{1}]", new Object[]{reason.getComponentName(), reason.getReason()});
            } else {
                boolean isIdle = true;
                LOG.log(IDLE_REASONS_LEVEL, "Checking for idle because {0} reported idleness for reason [{1}]", new Object[]{reason.getComponentName(), reason.getReason()});
                for (DriverIdlenessSource idlenessSource : this.idlenessSources) {
                    IdleMessage idleMessage = idlenessSource.getIdleStatus();
                    LOG.log(IDLE_REASONS_LEVEL, "[{0}] is reporting {1} because [{2}].", new Object[]{idleMessage.getComponentName(), idleMessage.isIdle() ? "idle" : "not idle", idleMessage.getReason()});
                    isIdle &= idleMessage.isIdle();
                }
                if (isIdle) {
                    LOG.log(Level.INFO, "All components indicated idle. Initiating Driver shutdown.");
                    ((DriverStatusManager)this.driverStatusManager.get()).onComplete();
                }
            }
        }
    }
}

