/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.idle;

import javax.inject.Inject;
import org.apache.reef.runtime.common.driver.idle.DriverIdleManager;
import org.apache.reef.runtime.common.driver.idle.DriverIdlenessSource;
import org.apache.reef.runtime.common.driver.idle.IdleMessage;
import org.apache.reef.tang.InjectionFuture;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.Clock;
import org.apache.reef.wake.time.runtime.event.IdleClock;

public final class ClockIdlenessSource
implements DriverIdlenessSource,
EventHandler<IdleClock> {
    private static final String COMPONENT_NAME = "Clock";
    private static final String IDLE_REASON = "The clock reported idle.";
    private static final IdleMessage IDLE_MESSAGE = new IdleMessage("Clock", "The clock reported idle.", true);
    private static final String NOT_IDLE_REASON = "The clock reported not idle.";
    private static final IdleMessage NOT_IDLE_MESSAGE = new IdleMessage("Clock", "The clock reported not idle.", false);
    private final InjectionFuture<DriverIdleManager> driverIdleManager;
    private final Clock clock;

    @Inject
    ClockIdlenessSource(InjectionFuture<DriverIdleManager> driverIdleManager, Clock clock) {
        this.driverIdleManager = driverIdleManager;
        this.clock = clock;
    }

    @Override
    public synchronized IdleMessage getIdleStatus() {
        if (this.clock.isIdle()) {
            return IDLE_MESSAGE;
        }
        return NOT_IDLE_MESSAGE;
    }

    public synchronized void onNext(IdleClock idleClock) {
        ((DriverIdleManager)this.driverIdleManager.get()).onPotentiallyIdle(IDLE_MESSAGE);
    }
}

