/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.evaluator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorManager;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorManagerFactory;
import org.apache.reef.runtime.common.driver.resourcemanager.ResourceAllocationEvent;
import org.apache.reef.util.Optional;
import org.apache.reef.util.SingletonAsserter;

@DriverSide
@Private
public final class Evaluators
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(Evaluators.class.getName());
    private final Map<String, EvaluatorManager> evaluators = new HashMap<String, EvaluatorManager>();

    @Inject
    Evaluators() {
        LOG.log(Level.FINE, "Instantiated 'Evaluators'");
        assert (SingletonAsserter.assertSingleton(Evaluators.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<EvaluatorManager> evaluatorsCopy;
        Evaluators evaluators = this;
        synchronized (evaluators) {
            evaluatorsCopy = new ArrayList<EvaluatorManager>(this.evaluators.values());
        }
        for (EvaluatorManager evaluatorManager : evaluatorsCopy) {
            LOG.log(Level.WARNING, "Unclean shutdown of evaluator {0}", evaluatorManager.getId());
            if (evaluatorManager.isClosed()) continue;
            evaluatorManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean allEvaluatorsAreClosed() {
        Map<String, EvaluatorManager> map = this.evaluators;
        synchronized (map) {
            for (EvaluatorManager eval : this.evaluators.values()) {
                if (eval.isClosed()) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized Optional<EvaluatorManager> get(String evaluatorId) {
        return Optional.ofNullable((Object)this.evaluators.get(evaluatorId));
    }

    public synchronized void put(EvaluatorManagerFactory evaluatorManagerFactory, ResourceAllocationEvent evaluatorMsg) {
        this.put(evaluatorManagerFactory.getNewEvaluatorManager(evaluatorMsg));
    }

    public synchronized void put(EvaluatorManager evaluatorManager) {
        String evaluatorId = evaluatorManager.getId();
        EvaluatorManager prev = this.evaluators.put(evaluatorId, evaluatorManager);
        LOG.log(Level.FINEST, "Adding: {0} previous: {1}", new Object[]{evaluatorId, prev});
        if (prev != null) {
            throw new IllegalArgumentException("Trying to re-add an Evaluator that is already known: " + evaluatorId);
        }
    }
}

