/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.evaluator;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorState;

@DriverSide
@Private
final class EvaluatorStatusManager {
    private static final Logger LOG = Logger.getLogger(EvaluatorStatusManager.class.getName());
    private EvaluatorState state = EvaluatorState.ALLOCATED;

    @Inject
    private EvaluatorStatusManager() {
        LOG.log(Level.FINE, "Instantiated 'EvaluatorStatusManager'");
    }

    private static boolean isLegal(EvaluatorState from, EvaluatorState to) {
        return true;
    }

    synchronized void setRunning() {
        this.setState(EvaluatorState.RUNNING);
    }

    synchronized void setSubmitted() {
        this.setState(EvaluatorState.SUBMITTED);
    }

    synchronized void setDone() {
        this.setState(EvaluatorState.DONE);
    }

    synchronized void setFailed() {
        this.setState(EvaluatorState.FAILED);
    }

    synchronized void setKilled() {
        this.setState(EvaluatorState.KILLED);
    }

    synchronized boolean isRunning() {
        return this.state.equals((Object)EvaluatorState.RUNNING);
    }

    synchronized boolean isDoneOrFailedOrKilled() {
        return this.state == EvaluatorState.DONE || this.state == EvaluatorState.FAILED || this.state == EvaluatorState.KILLED;
    }

    synchronized boolean isAllocatedOrSubmittedOrRunning() {
        return this.state == EvaluatorState.ALLOCATED || this.state == EvaluatorState.SUBMITTED || this.state == EvaluatorState.RUNNING;
    }

    synchronized boolean isSubmitted() {
        return EvaluatorState.SUBMITTED == this.state;
    }

    synchronized boolean isAllocated() {
        return EvaluatorState.ALLOCATED == this.state;
    }

    public synchronized String toString() {
        return this.state.toString();
    }

    private synchronized void setState(EvaluatorState state) {
        if (!EvaluatorStatusManager.isLegal(this.state, state)) {
            throw new IllegalStateException("Illegal state transition from '" + (Object)((Object)this.state) + "' to '" + (Object)((Object)state) + "'");
        }
        this.state = state;
    }
}

