/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.evaluator;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.client.FailedRuntime;
import org.apache.reef.exception.EvaluatorException;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorManager;
import org.apache.reef.runtime.common.driver.evaluator.Evaluators;
import org.apache.reef.util.Optional;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.remote.RemoteMessage;

@Private
public final class EvaluatorResourceManagerErrorHandler
implements EventHandler<RemoteMessage<ReefServiceProtos.RuntimeErrorProto>> {
    private static final Logger LOG = Logger.getLogger(EvaluatorResourceManagerErrorHandler.class.toString());
    private final Evaluators evaluators;

    @Inject
    EvaluatorResourceManagerErrorHandler(Evaluators evaluators) {
        this.evaluators = evaluators;
        LOG.log(Level.FINE, "Instantiated 'EvaluatorResourceManagerErrorHandler'");
    }

    public void onNext(RemoteMessage<ReefServiceProtos.RuntimeErrorProto> runtimeErrorProtoRemoteMessage) {
        ReefServiceProtos.RuntimeErrorProto runtimeErrorProto = (ReefServiceProtos.RuntimeErrorProto)runtimeErrorProtoRemoteMessage.getMessage();
        FailedRuntime error = new FailedRuntime(runtimeErrorProto);
        String evaluatorId = error.getId();
        LOG.log(Level.WARNING, "Runtime error: " + error);
        EvaluatorException evaluatorException = error.getReason().isPresent() ? new EvaluatorException(evaluatorId, (Throwable)error.getReason().get()) : new EvaluatorException(evaluatorId, "Runtime error");
        Optional<EvaluatorManager> evaluatorManager = this.evaluators.get(evaluatorId);
        if (evaluatorManager.isPresent()) {
            ((EvaluatorManager)evaluatorManager.get()).onEvaluatorException(evaluatorException);
        } else {
            LOG.log(Level.WARNING, "Unknown evaluator runtime error: " + error);
        }
    }
}

