/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.evaluator;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.context.ActiveContext;
import org.apache.reef.driver.context.ClosedContext;
import org.apache.reef.driver.context.ContextMessage;
import org.apache.reef.driver.context.FailedContext;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.evaluator.CompletedEvaluator;
import org.apache.reef.driver.evaluator.FailedEvaluator;
import org.apache.reef.driver.parameters.ContextActiveHandlers;
import org.apache.reef.driver.parameters.ContextClosedHandlers;
import org.apache.reef.driver.parameters.ContextFailedHandlers;
import org.apache.reef.driver.parameters.ContextMessageHandlers;
import org.apache.reef.driver.parameters.DriverRestartCompletedHandlers;
import org.apache.reef.driver.parameters.DriverRestartContextActiveHandlers;
import org.apache.reef.driver.parameters.DriverRestartTaskRunningHandlers;
import org.apache.reef.driver.parameters.EvaluatorAllocatedHandlers;
import org.apache.reef.driver.parameters.EvaluatorCompletedHandlers;
import org.apache.reef.driver.parameters.EvaluatorDispatcherThreads;
import org.apache.reef.driver.parameters.EvaluatorFailedHandlers;
import org.apache.reef.driver.parameters.ServiceContextActiveHandlers;
import org.apache.reef.driver.parameters.ServiceContextClosedHandlers;
import org.apache.reef.driver.parameters.ServiceContextFailedHandlers;
import org.apache.reef.driver.parameters.ServiceContextMessageHandlers;
import org.apache.reef.driver.parameters.ServiceDriverRestartCompletedHandlers;
import org.apache.reef.driver.parameters.ServiceDriverRestartContextActiveHandlers;
import org.apache.reef.driver.parameters.ServiceDriverRestartTaskRunningHandlers;
import org.apache.reef.driver.parameters.ServiceEvaluatorAllocatedHandlers;
import org.apache.reef.driver.parameters.ServiceEvaluatorCompletedHandlers;
import org.apache.reef.driver.parameters.ServiceEvaluatorFailedHandlers;
import org.apache.reef.driver.parameters.ServiceTaskCompletedHandlers;
import org.apache.reef.driver.parameters.ServiceTaskFailedHandlers;
import org.apache.reef.driver.parameters.ServiceTaskMessageHandlers;
import org.apache.reef.driver.parameters.ServiceTaskRunningHandlers;
import org.apache.reef.driver.parameters.ServiceTaskSuspendedHandlers;
import org.apache.reef.driver.parameters.TaskCompletedHandlers;
import org.apache.reef.driver.parameters.TaskFailedHandlers;
import org.apache.reef.driver.parameters.TaskMessageHandlers;
import org.apache.reef.driver.parameters.TaskRunningHandlers;
import org.apache.reef.driver.parameters.TaskSuspendedHandlers;
import org.apache.reef.driver.task.CompletedTask;
import org.apache.reef.driver.task.FailedTask;
import org.apache.reef.driver.task.RunningTask;
import org.apache.reef.driver.task.SuspendedTask;
import org.apache.reef.driver.task.TaskMessage;
import org.apache.reef.runtime.common.DriverRestartCompleted;
import org.apache.reef.runtime.common.driver.DriverExceptionHandler;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorManager;
import org.apache.reef.runtime.common.utils.DispatchingEStage;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.wake.EventHandler;

public final class EvaluatorMessageDispatcher {
    private static final Logger LOG = Logger.getLogger(EvaluatorMessageDispatcher.class.getName());
    private final DispatchingEStage applicationDispatcher;
    private final DispatchingEStage serviceDispatcher;
    private final DispatchingEStage driverRestartApplicationDispatcher;
    private final DispatchingEStage driverRestartServiceDispatcher;

    @Inject
    EvaluatorMessageDispatcher(@Parameter(value=ContextActiveHandlers.class) Set<EventHandler<ActiveContext>> contextActiveHandlers, @Parameter(value=ContextClosedHandlers.class) Set<EventHandler<ClosedContext>> contextClosedHandlers, @Parameter(value=ContextFailedHandlers.class) Set<EventHandler<FailedContext>> contextFailedHandlers, @Parameter(value=ContextMessageHandlers.class) Set<EventHandler<ContextMessage>> contextMessageHandlers, @Parameter(value=ServiceContextActiveHandlers.class) Set<EventHandler<ActiveContext>> serviceContextActiveHandlers, @Parameter(value=ServiceContextClosedHandlers.class) Set<EventHandler<ClosedContext>> serviceContextClosedHandlers, @Parameter(value=ServiceContextFailedHandlers.class) Set<EventHandler<FailedContext>> serviceContextFailedHandlers, @Parameter(value=ServiceContextMessageHandlers.class) Set<EventHandler<ContextMessage>> serviceContextMessageHandlers, @Parameter(value=TaskRunningHandlers.class) Set<EventHandler<RunningTask>> taskRunningHandlers, @Parameter(value=TaskCompletedHandlers.class) Set<EventHandler<CompletedTask>> taskCompletedHandlers, @Parameter(value=TaskSuspendedHandlers.class) Set<EventHandler<SuspendedTask>> taskSuspendedHandlers, @Parameter(value=TaskMessageHandlers.class) Set<EventHandler<TaskMessage>> taskMessageEventHandlers, @Parameter(value=TaskFailedHandlers.class) Set<EventHandler<FailedTask>> taskExceptionEventHandlers, @Parameter(value=ServiceTaskRunningHandlers.class) Set<EventHandler<RunningTask>> serviceTaskRunningEventHandlers, @Parameter(value=ServiceTaskCompletedHandlers.class) Set<EventHandler<CompletedTask>> serviceTaskCompletedEventHandlers, @Parameter(value=ServiceTaskSuspendedHandlers.class) Set<EventHandler<SuspendedTask>> serviceTaskSuspendedEventHandlers, @Parameter(value=ServiceTaskMessageHandlers.class) Set<EventHandler<TaskMessage>> serviceTaskMessageEventHandlers, @Parameter(value=ServiceTaskFailedHandlers.class) Set<EventHandler<FailedTask>> serviceTaskExceptionEventHandlers, @Parameter(value=EvaluatorAllocatedHandlers.class) Set<EventHandler<AllocatedEvaluator>> evaluatorAllocatedHandlers, @Parameter(value=EvaluatorFailedHandlers.class) Set<EventHandler<FailedEvaluator>> evaluatorFailedHandlers, @Parameter(value=EvaluatorCompletedHandlers.class) Set<EventHandler<CompletedEvaluator>> evaluatorCompletedHandlers, @Parameter(value=ServiceEvaluatorAllocatedHandlers.class) Set<EventHandler<AllocatedEvaluator>> serviceEvaluatorAllocatedEventHandlers, @Parameter(value=ServiceEvaluatorFailedHandlers.class) Set<EventHandler<FailedEvaluator>> serviceEvaluatorFailedHandlers, @Parameter(value=ServiceEvaluatorCompletedHandlers.class) Set<EventHandler<CompletedEvaluator>> serviceEvaluatorCompletedHandlers, @Parameter(value=DriverRestartTaskRunningHandlers.class) Set<EventHandler<RunningTask>> driverRestartTaskRunningHandlers, @Parameter(value=DriverRestartContextActiveHandlers.class) Set<EventHandler<ActiveContext>> driverRestartActiveContextHandlers, @Parameter(value=DriverRestartCompletedHandlers.class) Set<EventHandler<DriverRestartCompleted>> driverRestartCompletedHandlers, @Parameter(value=ServiceDriverRestartTaskRunningHandlers.class) Set<EventHandler<RunningTask>> serviceDriverRestartTaskRunningHandlers, @Parameter(value=ServiceDriverRestartContextActiveHandlers.class) Set<EventHandler<ActiveContext>> serviceDriverRestartActiveContextHandlers, @Parameter(value=ServiceDriverRestartCompletedHandlers.class) Set<EventHandler<DriverRestartCompleted>> serviceDriverRestartCompletedHandlers, @Parameter(value=EvaluatorDispatcherThreads.class) int numberOfThreads, @Parameter(value=EvaluatorManager.EvaluatorIdentifier.class) String evaluatorIdentifier, DriverExceptionHandler driverExceptionHandler) {
        this.serviceDispatcher = new DispatchingEStage(driverExceptionHandler, numberOfThreads, evaluatorIdentifier);
        this.applicationDispatcher = new DispatchingEStage(this.serviceDispatcher);
        this.driverRestartApplicationDispatcher = new DispatchingEStage(this.serviceDispatcher);
        this.driverRestartServiceDispatcher = new DispatchingEStage(this.serviceDispatcher);
        this.applicationDispatcher.register(ActiveContext.class, contextActiveHandlers);
        this.applicationDispatcher.register(ClosedContext.class, contextClosedHandlers);
        this.applicationDispatcher.register(FailedContext.class, contextFailedHandlers);
        this.applicationDispatcher.register(ContextMessage.class, contextMessageHandlers);
        this.serviceDispatcher.register(ActiveContext.class, serviceContextActiveHandlers);
        this.serviceDispatcher.register(ClosedContext.class, serviceContextClosedHandlers);
        this.serviceDispatcher.register(FailedContext.class, serviceContextFailedHandlers);
        this.serviceDispatcher.register(ContextMessage.class, serviceContextMessageHandlers);
        this.applicationDispatcher.register(RunningTask.class, taskRunningHandlers);
        this.applicationDispatcher.register(CompletedTask.class, taskCompletedHandlers);
        this.applicationDispatcher.register(SuspendedTask.class, taskSuspendedHandlers);
        this.applicationDispatcher.register(TaskMessage.class, taskMessageEventHandlers);
        this.applicationDispatcher.register(FailedTask.class, taskExceptionEventHandlers);
        this.serviceDispatcher.register(RunningTask.class, serviceTaskRunningEventHandlers);
        this.serviceDispatcher.register(CompletedTask.class, serviceTaskCompletedEventHandlers);
        this.serviceDispatcher.register(SuspendedTask.class, serviceTaskSuspendedEventHandlers);
        this.serviceDispatcher.register(TaskMessage.class, serviceTaskMessageEventHandlers);
        this.serviceDispatcher.register(FailedTask.class, serviceTaskExceptionEventHandlers);
        this.applicationDispatcher.register(FailedEvaluator.class, evaluatorFailedHandlers);
        this.applicationDispatcher.register(CompletedEvaluator.class, evaluatorCompletedHandlers);
        this.applicationDispatcher.register(AllocatedEvaluator.class, evaluatorAllocatedHandlers);
        this.serviceDispatcher.register(FailedEvaluator.class, serviceEvaluatorFailedHandlers);
        this.serviceDispatcher.register(CompletedEvaluator.class, serviceEvaluatorCompletedHandlers);
        this.serviceDispatcher.register(AllocatedEvaluator.class, serviceEvaluatorAllocatedEventHandlers);
        this.driverRestartApplicationDispatcher.register(RunningTask.class, driverRestartTaskRunningHandlers);
        this.driverRestartApplicationDispatcher.register(ActiveContext.class, driverRestartActiveContextHandlers);
        this.driverRestartApplicationDispatcher.register(DriverRestartCompleted.class, driverRestartCompletedHandlers);
        this.driverRestartServiceDispatcher.register(RunningTask.class, serviceDriverRestartTaskRunningHandlers);
        this.driverRestartServiceDispatcher.register(ActiveContext.class, serviceDriverRestartActiveContextHandlers);
        this.driverRestartServiceDispatcher.register(DriverRestartCompleted.class, serviceDriverRestartCompletedHandlers);
        LOG.log(Level.FINE, "Instantiated 'EvaluatorMessageDispatcher'");
    }

    public void onEvaluatorAllocated(AllocatedEvaluator allocatedEvaluator) {
        this.dispatch(AllocatedEvaluator.class, allocatedEvaluator);
    }

    public void onEvaluatorFailed(FailedEvaluator failedEvaluator) {
        this.dispatch(FailedEvaluator.class, failedEvaluator);
    }

    public void onEvaluatorCompleted(CompletedEvaluator completedEvaluator) {
        this.dispatch(CompletedEvaluator.class, completedEvaluator);
    }

    public void onTaskRunning(RunningTask runningTask) {
        this.dispatch(RunningTask.class, runningTask);
    }

    public void onTaskCompleted(CompletedTask completedTask) {
        this.dispatch(CompletedTask.class, completedTask);
    }

    public void onTaskSuspended(SuspendedTask suspendedTask) {
        this.dispatch(SuspendedTask.class, suspendedTask);
    }

    public void onTaskMessage(TaskMessage taskMessage) {
        this.dispatch(TaskMessage.class, taskMessage);
    }

    public void onTaskFailed(FailedTask failedTask) {
        this.dispatch(FailedTask.class, failedTask);
    }

    public void onContextActive(ActiveContext activeContext) {
        this.dispatch(ActiveContext.class, activeContext);
    }

    public void onContextClose(ClosedContext closedContext) {
        this.dispatch(ClosedContext.class, closedContext);
    }

    public void onContextFailed(FailedContext failedContext) {
        this.dispatch(FailedContext.class, failedContext);
    }

    public void onContextMessage(ContextMessage contextMessage) {
        this.dispatch(ContextMessage.class, contextMessage);
    }

    public void onDriverRestartTaskRunning(RunningTask runningTask) {
        this.dispatchForRestartedDriver(RunningTask.class, runningTask);
    }

    public void OnDriverRestartContextActive(ActiveContext activeContext) {
        this.dispatchForRestartedDriver(ActiveContext.class, activeContext);
    }

    public void OnDriverRestartCompleted(DriverRestartCompleted restartCompleted) {
        this.dispatchForRestartedDriver(DriverRestartCompleted.class, restartCompleted);
    }

    boolean isEmpty() {
        return this.applicationDispatcher.isEmpty();
    }

    private <T, U extends T> void dispatch(Class<T> type, U message) {
        this.serviceDispatcher.onNext(type, message);
        this.applicationDispatcher.onNext(type, message);
    }

    private <T, U extends T> void dispatchForRestartedDriver(Class<T> type, U message) {
        this.driverRestartApplicationDispatcher.onNext(type, message);
        this.driverRestartServiceDispatcher.onNext(type, message);
    }
}

