/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.evaluator;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.driver.catalog.NodeDescriptor;
import org.apache.reef.driver.catalog.ResourceCatalog;
import org.apache.reef.driver.evaluator.EvaluatorType;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorDescriptorImpl;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorManager;
import org.apache.reef.runtime.common.driver.resourcemanager.NodeDescriptorHandler;
import org.apache.reef.runtime.common.driver.resourcemanager.ResourceAllocationEvent;
import org.apache.reef.runtime.common.driver.resourcemanager.ResourceStatusEvent;
import org.apache.reef.tang.Injector;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.exceptions.InjectionException;

@Private
@DriverSide
public final class EvaluatorManagerFactory {
    private static final Logger LOG = Logger.getLogger(EvaluatorManagerFactory.class.getName());
    private final Injector injector;
    private final ResourceCatalog resourceCatalog;

    @Inject
    EvaluatorManagerFactory(Injector injector, ResourceCatalog resourceCatalog, NodeDescriptorHandler nodeDescriptorHandler) {
        this.injector = injector;
        this.resourceCatalog = resourceCatalog;
    }

    private final EvaluatorManager getNewEvaluatorManagerInstance(String id, EvaluatorDescriptorImpl desc) {
        EvaluatorManager result;
        LOG.log(Level.FINEST, "Creating Evaluator Manager for Evaluator ID {0}", id);
        Injector child = this.injector.forkInjector();
        try {
            child.bindVolatileParameter(EvaluatorManager.EvaluatorIdentifier.class, (Object)id);
            child.bindVolatileParameter(EvaluatorManager.EvaluatorDescriptorName.class, (Object)desc);
        }
        catch (BindException e) {
            throw new RuntimeException("Unable to bind evaluator identifier and name.", e);
        }
        try {
            result = (EvaluatorManager)child.getInstance(EvaluatorManager.class);
        }
        catch (InjectionException e) {
            throw new RuntimeException("Unable to instantiate a new EvaluatorManager for Evaluator ID: " + id, e);
        }
        return result;
    }

    public final EvaluatorManager getNewEvaluatorManager(ResourceAllocationEvent resourceAllocationEvent) {
        NodeDescriptor nodeDescriptor = this.resourceCatalog.getNode(resourceAllocationEvent.getNodeId());
        if (nodeDescriptor == null) {
            throw new RuntimeException("Unknown resource: " + resourceAllocationEvent.getNodeId());
        }
        EvaluatorDescriptorImpl evaluatorDescriptor = new EvaluatorDescriptorImpl(nodeDescriptor, EvaluatorType.UNDECIDED, resourceAllocationEvent.getResourceMemory(), (Integer)resourceAllocationEvent.getVirtualCores().get());
        LOG.log(Level.FINEST, "Resource allocation: new evaluator id[{0}]", resourceAllocationEvent.getIdentifier());
        return this.getNewEvaluatorManagerInstance(resourceAllocationEvent.getIdentifier(), evaluatorDescriptor);
    }

    public final EvaluatorManager createForEvaluatorFailedDuringDriverRestart(ResourceStatusEvent resourceStatusEvent) {
        if (!((Boolean)resourceStatusEvent.getIsFromPreviousDriver().get()).booleanValue()) {
            throw new RuntimeException("Invalid resourceStatusEvent, must be status for resource from previous Driver.");
        }
        return this.getNewEvaluatorManagerInstance(resourceStatusEvent.getIdentifier(), new EvaluatorDescriptorImpl(null, EvaluatorType.UNDECIDED, 128, 1));
    }
}

