/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.evaluator;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.proto.EvaluatorRuntimeProtocol;
import org.apache.reef.proto.ReefServiceProtos;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorManager;
import org.apache.reef.runtime.common.driver.evaluator.EvaluatorManagerFactory;
import org.apache.reef.runtime.common.driver.evaluator.Evaluators;
import org.apache.reef.util.Optional;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.remote.RemoteMessage;

@Private
@DriverSide
public final class EvaluatorHeartbeatHandler
implements EventHandler<RemoteMessage<EvaluatorRuntimeProtocol.EvaluatorHeartbeatProto>> {
    private static final Logger LOG = Logger.getLogger(EvaluatorHeartbeatHandler.class.getName());
    private final Evaluators evaluators;
    private final EvaluatorManagerFactory evaluatorManagerFactory;

    @Inject
    EvaluatorHeartbeatHandler(Evaluators evaluators, EvaluatorManagerFactory evaluatorManagerFactory) {
        this.evaluators = evaluators;
        this.evaluatorManagerFactory = evaluatorManagerFactory;
    }

    public void onNext(RemoteMessage<EvaluatorRuntimeProtocol.EvaluatorHeartbeatProto> evaluatorHeartbeatMessage) {
        EvaluatorRuntimeProtocol.EvaluatorHeartbeatProto heartbeat = (EvaluatorRuntimeProtocol.EvaluatorHeartbeatProto)evaluatorHeartbeatMessage.getMessage();
        ReefServiceProtos.EvaluatorStatusProto status = heartbeat.getEvaluatorStatus();
        String evaluatorId = status.getEvaluatorId();
        LOG.log(Level.FINEST, "TIME: Begin Heartbeat {0}", evaluatorId);
        LOG.log(Level.FINEST, "Heartbeat from Evaluator {0} with state {1} timestamp {2} from remoteId {3}", new Object[]{evaluatorId, status.getState(), heartbeat.getTimestamp(), evaluatorHeartbeatMessage.getIdentifier()});
        Optional<EvaluatorManager> evaluatorManager = this.evaluators.get(evaluatorId);
        if (!evaluatorManager.isPresent()) {
            StringBuilder message = new StringBuilder("Contact from unknown Evaluator with identifier '");
            message.append(evaluatorId);
            if (heartbeat.hasEvaluatorStatus()) {
                message.append("' with state '");
                message.append((Object)status.getState());
            }
            message.append('\'');
            throw new RuntimeException(message.toString());
        }
        ((EvaluatorManager)evaluatorManager.get()).onEvaluatorHeartbeatMessage(evaluatorHeartbeatMessage);
        LOG.log(Level.FINEST, "TIME: End Heartbeat {0}", evaluatorId);
    }
}

