/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.evaluator;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;

@DriverSide
@Private
final class EvaluatorHeartBeatSanityChecker {
    private static final Logger LOG = Logger.getLogger(EvaluatorHeartBeatSanityChecker.class.getName());
    private final Map<String, Long> knownTimeStamps = new HashMap<String, Long>();

    @Inject
    EvaluatorHeartBeatSanityChecker() {
    }

    final synchronized void check(String id, long timeStamp) {
        if (this.knownTimeStamps.containsKey(id)) {
            long oldTimeStamp = this.knownTimeStamps.get(id);
            LOG.log(Level.FINEST, "TIMESTAMP CHECKER: id [ " + id + " ], old timestamp [ " + oldTimeStamp + " ], new timestamp [ " + timeStamp + " ]");
            if (oldTimeStamp > timeStamp) {
                String msg = "Received an old heartbeat with timestamp `" + timeStamp + "` while earlier receiving one with timestamp `" + oldTimeStamp + "`";
                LOG.log(Level.SEVERE, msg);
                throw new RuntimeException(msg);
            }
        }
        this.knownTimeStamps.put(id, timeStamp);
    }
}

