/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.common.driver.evaluator;

import org.apache.reef.annotations.audience.DriverSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.driver.catalog.NodeDescriptor;
import org.apache.reef.driver.evaluator.EvaluatorDescriptor;
import org.apache.reef.driver.evaluator.EvaluatorType;

@Private
@DriverSide
final class EvaluatorDescriptorImpl
implements EvaluatorDescriptor {
    private final NodeDescriptor nodeDescriptor;
    private final int megaBytes;
    private final int numberOfCores;
    private EvaluatorType type;

    public EvaluatorDescriptorImpl(NodeDescriptor nodeDescriptor, EvaluatorType type, int megaBytes, int numberOfCores) {
        this.nodeDescriptor = nodeDescriptor;
        this.type = type;
        this.megaBytes = megaBytes;
        this.numberOfCores = numberOfCores;
    }

    @Override
    public NodeDescriptor getNodeDescriptor() {
        return this.nodeDescriptor;
    }

    @Override
    public synchronized EvaluatorType getType() {
        return this.type;
    }

    public synchronized void setType(EvaluatorType type) {
        if (this.getType() != EvaluatorType.UNDECIDED) {
            throw new RuntimeException("Unable to change state of an Evaluator of Type: " + (Object)((Object)this.getType()));
        }
        this.type = type;
    }

    @Override
    public int getMemory() {
        return this.megaBytes;
    }

    @Override
    public int getNumberOfCores() {
        return this.numberOfCores;
    }
}

